import configparser
import json

import matplotlib.pyplot as plt
import os, sys
BASE_DIR = os.path.dirname(os.path.abspath(__file__))
BASE_DIR = os.path.dirname(BASE_DIR)
sys.path.append(BASE_DIR)

import argparse
import pickle
from utils.utils import set_seed
import numpy as np
import os


def read_config_file(config_path):
    if ".ini" in config_path:
        config = configparser.ConfigParser()
        config.read(config_path)
    elif ".json" in config_path:
        with open(config_path, "r") as f:
            config = json.load(f)
    else:
        raise NotImplementedError("No implement read")
    return config



def main(args=None):

    if args.config_file:
        config = read_config_file(args.config_file)
        files = config['General']['files']
        labels = config['General']['labels']
        model_name = config['General']['model_name']
        smooth_gamma = config['General']['smooth_gamma']
    else:
        raise FileNotFoundError("no config file")

    fig, ax1 = plt.subplots(figsize=(15, 5))
    # 旋转x轴标签
    plt.xticks(rotation=45, ha='right')

    ax2 = ax1.twinx()
    count = -2
    for _filename, _label in zip(files, labels):
        hard_cuda = 0 if "hard_cuda-0" in _filename else 1
        with open(_filename, "rb") as f:
            data = pickle.load(f)["token_speed_gpu"]
            x = []
            y = [1]
            gpus = []
            for length, value in data.items():
                x.append(length)
                y.append(
                    value["time"] * (1 - smooth_gamma) + y[-1] * smooth_gamma
                )
                # gpu_ = round(int(value["end_gpu_util"].split("\n")[0]) / 1024, 2)
                if hard_cuda == 1:
                    gpu_ = round(int(value["end_gpu_util"].split("\n")[0]) / 1024, 2)
                else:
                    str_list = [num.strip() for num in value["end_gpu_util"].split("\n") if num]
                    int_list = [int(num) for num in str_list if num]
                    gpu_ = round(sum(int_list) / 1024, 2)
                gpus.append(gpu_)
            y.pop(0)

            x = np.array(x)

            ax2.plot(x, y, marker='o', label=_label, linewidth=2.5)
            ax1.bar(x + count * 100 - 50, gpus, width=100, label=_label)
        count += 1

    # 设置坐标轴标签
    ax1.set_xlabel("Token Length", fontsize=14)
    ax2.set_ylabel("Speed (second)", fontsize=14)
    plt.xticks(x, [str(int(l / 1024)) + "k" for l in x])

    ax1.set_ylabel("Gpu Util (GB)", fontsize=14)
    # ax2.tick_params('y', colors='r')
    # 设置标题
    plt.title("Speed & Memory Used: {}".format(model_name), fontsize=14)
    # plt.ylim(0, 1.2)

    plt.subplots_adjust(left=0.06, right=0.94, bottom=0.14, top=0.92)

    plt.legend()

    plt.savefig("speed_memory_{}.png".format(model_name))

    plt.show()


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("-c", "--config_file", type=str, default="../conf/speed-memory-result7.json")
    args = parser.parse_args()
    main(args)
