import matplotlib.pyplot as plt
import numpy as np

# 定义f：
def f(x):

    nums = - np.arange(x)
    print("nums: {}".format(nums))
    exp_list = np.exp(nums)
    S = sum(exp_list)
    y = exp_list[-1] / S

    return y

def ff(t, N):
    assert t > N, "t > N"
    nums = - np.arange(N)
    print("before nums: {}".format(nums))
    nums_ = [nums[-1]] * (t - N)
    nums_.extend(nums)
    nums = nums_
    print("extend nums: {}".format(nums))
    exp_list = np.exp(nums)
    SS = sum(exp_list)
    y = exp_list[-1] / SS

    return y

def make_data(t, N, func="f"):
    assert t > 1, "t > 1"
    # 生成 t 值
    t_list = np.arange(1, t)
    # t_values = [1, 2, 3, 4, 5, 6, 7, 8, 9]

    # 计算对应的 y 值
    y_values = []
    if func == "f":
        for t in t_list:
            y = f(t)
            y_values.append(y)
    elif func == "ff":
        for t in t_list:
            if t > N:
                y = ff(t, N)
                y_values.append(y)
        t_list = t_list[N:]

    return t_list, y_values

def make_plot(t_list, y_values, t_list2=None, y_values2=None, func1="f", func2="ff"):
    # 绘制图表
    plt.plot(t_list, y_values, label=func1)

    if t_list2 is not None:
        plt.plot(t_list2, y_values2, label=func2)

    plt.xlabel('t')
    plt.ylabel('value')
    plt.xticks(t_list)
    plt.title('函数图表')
    plt.legend()
    plt.grid(True)
    plt.show()


# 1.
# t = 2048
# N = 512
t = 40
N = 10
t1_, y1_ = make_data(t, N, "f")
t2_, y2_ = make_data(t, N, "ff")
# make_plot(t1_[510:520], y1_[510:520], t2_[:10], y2_[:10])
make_plot(t1_[N-1:], y1_[N-1:], t2_, y2_)




