#!/bin/bash


echo "############################ first: run ppl task ############################"

model_path="/data/persist/models/llama-3b"
methods=("dynamic-ntk")
dataset="/data/persist/dataset/gov_report/test.txt"
datatset_name="gov-report-data"
batch_size=1
log_dir="../logs"
cuda="0"
seed=0


source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

for method in "${methods[@]}"; do
  current_date=$(date "+%Y-%m-%d_%H-%M-%S")
  save_file="stats_$(basename $model_path)_'$method'_'$datatset_name'_'$current_date'_'$seed'.pkl"
  python_command="python evaluate_ppl.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"
  echo $python_command
  eval $python_command || \
    echo "completed, but continuing..."
done

echo "############################ second: run passkey task ############################"

model_path="/data/persist/models/llama-3b"
methods=("dynamic-ntk")
dataset="../datas/passkey_data_dup-100.json"
batch_size=1
log_dir="../logs"
cuda="auto"
seed=0

for method in "${methods[@]}"; do

  current_date=$(date "+%Y-%m-%d_%H-%M-%S")
  save_file="retrieval_acc_$(basename $model_path)_'$method'_$(basename $dataset)_'$seed'_'$current_date'.pkl"
  python_command="python evaluate_passkey_retrieval.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"

  echo $python_command
  eval $python_command || echo "completed"
done


echo "############################ third: run generation task ############################"


model_path="/data/persist/models/llama-3b"
methods=("dynamic-ntk")
dataset="/data/persist/dataset/gov_report/test.txt"
datatset_name="gov-report-data"
batch_size=1
log_dir="../logs"
cuda="0"
seed=0


source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

for method in "${methods[@]}"; do
  current_date=$(date "+%Y-%m-%d_%H-%M-%S")
  save_file="rouge_$(basename $model_path)_'$method'_'$datatset_name'_'$current_date'_'$seed'.pkl"
  python_command="python evaluate_generation.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"
  echo $python_command
  eval $python_command || \
    echo "completed, but continuing..."
done





