#!/bin/bash

#model_path="/data/persist/models/llama2-7b-chat"
model_paths=("/data/persist/models/vicuna/vicuna-13b-v1.3" "/data/persist/models/llama-3b")

methods=("leaky-rerope-weave-v20-other")
dataset="../datas/passkey-data_dup-100_answer-6bit.json"

batch_size=1
log_dir="../logs"
cuda="3"
seed=0

#source /root/anaconda3/etc/profile.d/conda.sh
conda activate rerope

# 记录开始时间
start_time=$(date +%s)

for model_path in "${model_paths[@]}"; do
  for method in "${methods[@]}"; do
    echo "############################ run passkey task: $method ############################"
    current_date=$(date "+%Y-%m-%d_%H-%M-%S")

    # 记录开始时间
    current_start_time=$(date +%s)

    save_file="retrieval_ablation_$(basename $model_path)_'$method'_$(basename $dataset)_'$seed'_'$current_date'.pkl"
    python_command="python ablation_passkey_retrieval.py --model_path $model_path --method $method --dataset $dataset --save_file $save_file --batch_size $batch_size --log_dir $log_dir --cuda $cuda --seed $seed"

    echo $python_command
    eval $python_command || echo "completed"

    # 记录结束时间
    current_end_time=$(date +%s)
    current_time_diff=$((current_end_time - current_start_time))
    current_minutes_diff=$((current_time_diff / 60))
    echo "${method} code running time: ${current_minutes_diff} minutes"

  done
done

# 记录结束时间
end_time=$(date +%s)
time_diff=$((end_time - start_time))
minutes_diff=$((time_diff / 60))
echo "total running: ${minutes_diff} minutes"


