from transformers import LlamaForCausalLM, AutoTokenizer
import torch

device = torch.device("cuda")

model = LlamaForCausalLM.from_pretrained("meta-llama/Meta-Llama-3-8B", device_map="auto")
tokenizer = AutoTokenizer.from_pretrained("meta-llama/Meta-Llama-3-8B")
tokenizer.pad_token_id = tokenizer.eos_token_id
EOS = "<|end_of_text|>"

if __name__ == "__main__":
    PROMPT = "TRANIO: Is this your speeding? nay, then, good night our part! PETRUCHIO: Be patient, gentlemen; I choose her for myself: If she and I be pleased, what's that to you? 'Tis bargain'd 'twixt us twain, being alone, That she shall still be curst in company. I tell you, 'tis incredible to believe How much she loves me: O, the kindest Kate! She hung about my neck; and kiss on kiss She vied so fast, protesting oath on oath, That in a twink she won me to her love. O, you are novices! 'tis a world to see, How tame, when men and women are alone, A meacock wretch can make the curstest shrew. Give me thy hand, Kate: I will unto Venice, To buy apparel 'gainst the wedding-day. Provide the feast, father, and bid the guests; I will be sure my Katharina shall be fine. BAPTISTA: I know not what to say: but give me your hands; God send you joy, Petruchio! 'tis a match. GREMIO: Amen, say we: we will be witnesses. PETRUCHIO: Father, and wife, and gentlemen, adieu; I will to Venice; Sunday comes apace: We will have rings and things and fine array; And kiss me, Kate, we will be married o'Sunday. GREMIO: Was ever match clapp'd up so suddenly? BAPTISTA: Faith, gentlemen, now I play a merchant's part, And venture madly on a desperate mart. TRANIO: 'Twas a commodity lay fretting by you: 'Twill bring you gain, or perish on the seas. BAPTISTA: The gain I seek is, quiet in the match. GREMIO: No doubt but he hath got a quiet catch. But now, Baptists, to your younger daughter: Now is the day we long have looked for: I am your neighbour, and was suitor first. TRANIO: And I am one that love Bianca more Than words can witness, or your thoughts can guess. GREMIO: Youngling, thou canst not love so dear as I. TRANIO: Graybeard, thy love doth freeze. GREMIO: But thine doth fry. Skipper, stand back: 'tis age that nourisheth. TRANIO: But youth in ladies' eyes that flourisheth. BAPTISTA: Content you, gentlemen: I will compound this strife: 'Tis deeds must win the prize; and he of both That can assure my daughter greatest dower Shall have my Bianca's love. Say, Signior Gremio, What can you assure her? GREMIO: First, as you know, my house within the city Is richly furnished with plate and gold; Basins and ewers to lave her dainty hands; My hangings all of Tyrian tapestry; In ivory coffers I have stuff'd my crowns; In cypress chests my arras counterpoints, Costly apparel, tents, and canopies, Fine linen, Turkey cushions boss'd with pearl, Valance of Venice gold in needlework, Pewter and brass and all things that belong To house or housekeeping: then, at my farm I have a hundred milch-kine to the pail, Sixscore fat oxen standing in my stalls, And all things answerable to this portion. Myself am struck in years, I must confess; And if I die to-morrow, this is hers, If whilst I live she will be only mine. TRANIO: That 'only' came well in."

    inputs = tokenizer(PROMPT + EOS, return_tensors="pt", 
                    padding="max_length", truncation=True).to(device)

    outputs = model(**inputs, labels=inputs.input_ids)
    outputs.loss.backward()

    from math import e
    print(e ** outputs.loss)

