# Copyright (c) 2018-2022, NVIDIA Corporation
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this
#    list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
#
# 3. Neither the name of the copyright holder nor the names of its
#    contributors may be used to endorse or promote products derived from
#    this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


from env.tasks.humanoid import Humanoid
from env.tasks.humanoid_amp import HumanoidAMP
from env.tasks.humanoid_amp_getup import HumanoidAMPGetup
from env.tasks.humanoid_perturb import HumanoidPerturb
from env.tasks.humanoid_amp_liftbox import HumanoidLiftbox
from env.tasks.humanoid_location import HumanoidLocation
from env.tasks.humanoid_strike import HumanoidStrike
from env.tasks.humanoid_amp_carrybox_reversecarry_dynamic import HumanoidCarryboxReverse
from env.tasks.humanoid_amp_carrybox_legacy import HumanoidCarrybox
from env.tasks.humanoid_amp_lift_height import HumanoidLiftHeight
from env.tasks.humanoid_amp_lift_box_hold_still import HumanoidLiftHeightHoldStill
from env.tasks.play_multi_humanoid_amp_lift_height import PlayMultiHumanoidLiftHeight
from env.tasks.play_multi_humanoid_amp_lift_box_hold_still import PlayMultiLiftHeightHoldStill
from env.tasks.share_humanoid_amp_lift_box_hold_still import ShareHumanoidLiftHeightHoldStill
from env.tasks.share_humanoid_amp_lift_box_hold_still_ft import ShareHumanoidLiftHeightHoldStillFinetune
from env.tasks.share_humanoid_amp_carrybox import ShareHumanoidCarrybox
from env.tasks.share_humanoid_amp_carrybox_ft import ShareHumanoidCarryboxFinetune
from env.tasks.share_humanoid_amp_carryobject_ft import ShareHumanoidCarryObjectFinetune
from env.tasks.humanoid_amp_carryobject_reversecarry_dynamic import HumanoidCarryObjectReverse
from env.tasks.share_humanoid_amp_carrybigbox import ShareHumanoidCarryBigBoxFinetune
from env.tasks.share_humanoid_amp_carrycross import ShareHumanoidCarryCrossFinetune
from env.tasks.humanoid_amp_carrybox_nostandpoint import HumanoidCarryboxReverseNoStandPoint
from env.tasks.share_humanoid_carry_box_no_task_allocation import ShareHumanoidCarryboxFinetuneNoAllocation
from env.tasks.share_humanoid_carry_box_no_stand_point import ShareHumanoidCarryboxFinetuneNoStandPoint
from env.tasks.humanoid_amp_carrybox_fixreverse import HumanoidCarryboxFixReverse
from env.tasks.humanoid_amp_liftbox_with_marker import HumanoidLiftboxWithMarker
from isaacgym import rlgpu
from env.tasks.vec_task_wrappers import VecTaskPythonWrapper


import json
import numpy as np


def warn_task_name():
    raise Exception(
        "Unrecognized task!\nTask should be one of: [BallBalance, Cartpole, CartpoleYUp, Ant, Humanoid, Anymal, FrankaCabinet, Quadcopter, ShadowHand, ShadowHandLSTM, ShadowHandFFOpenAI, ShadowHandFFOpenAITest, ShadowHandOpenAI, ShadowHandOpenAITest, Ingenuity]")


def parse_task(args, cfg, cfg_train, sim_params):

    # create native task and pass custom config
    device_id = args.device_id
    rl_device = args.rl_device

    cfg["seed"] = cfg_train.get("seed", -1)
    cfg_task = cfg["env"]
    cfg_task["seed"] = cfg["seed"]

    try:
        task = eval(args.task)(
            cfg=cfg,
            sim_params=sim_params,
            physics_engine=args.physics_engine,
            device_type=args.device,
            device_id=device_id,
            headless=args.headless)
    except NameError as e:
        print(e)
        warn_task_name()
    env = VecTaskPythonWrapper(task, rl_device, cfg_train.get(
        "clip_observations", np.inf), cfg_train.get("clip_actions", 1.0))

    return task, env
