clear;clc;
load('hemisphere_dataset_summary.mat')
days_lst = [1,2; 1,3; 2,1; 2,3; 3,1; 3,2];

annotator_lst = [1, 2, 3, 4; % dataset1
                 1, 3, 4, 5; % dataset2
                 1, 2, 3, 6];% dataset3
dpair = 1;
ann1 = 2;
ann2 = 3;

d1 = days_lst(dpair, 1);
d2 = days_lst(dpair, 2);
metrics_d1    = metrics_all{d1};
metrics_d2    = metrics_all{d2};
features_d1   = metrics_d1';
features_d2   = metrics_d2';
% features_d2 = align_features(features_d1, features_d2);

ann1_name = annotator_lst(d1, ann1);
choices1    = choices_all{ann1_name, d1};
choices1_gt = choices_gt_all{ann1_name, d1};
labels1      = choices1';
labels_gt_d1 = choices1_gt';

ann2_name = annotator_lst(d2, ann2);
choices2    = choices_all{ann2_name, d2};
choices2_gt = choices_gt_all{ann2_name, d2}; 
labels2      = choices2';
labels_gt_d2 = choices2_gt';

clear metrics_d1 metrics_d2 choices1 choices1_gt choices2 choices2_gt;
%%
n1 = size(features_d1,1);
n2 = size(features_d2,1);
X_combined = [features_d1; features_d2];

% Perform PCA
coeff = pca(X_combined);

% Project features onto the first three principal components
X_pca = X_combined * coeff(:,1:3);

% Separate features from dataset 1 and dataset 2
n1 = size(features_d1, 1);
X1_pca = X_pca(1:n1, :);
X2_pca = X_pca(n1+1:end, :);

% Plot PCA visualization for dataset 1
figure;
scatter3(X1_pca(labels_gt_d1==1,1), X1_pca(labels_gt_d1==1,2), X1_pca(labels_gt_d1==1,3), 'r', 'filled', 'DisplayName', 'Class 1');
hold on;
scatter3(X1_pca(labels_gt_d1==-1,1), X1_pca(labels_gt_d1==-1,2), X1_pca(labels_gt_d1==-1,3), 'b', 'filled', 'DisplayName', 'Class -1');
xlabel('PC1');
ylabel('PC2');
zlabel('PC3');
title('3D PCA Visualization of Features (Dataset 1)');
legend;
grid on;

% Plot PCA visualization for dataset 2
figure;
scatter3(X2_pca(labels_gt_d2==1,1), X2_pca(labels_gt_d2==1,2), X2_pca(labels_gt_d2==1,3), 'r', 'filled', 'DisplayName', 'Class 1');
hold on;
scatter3(X2_pca(labels_gt_d2==-1,1), X2_pca(labels_gt_d2==-1,2), X2_pca(labels_gt_d2==-1,3), 'b', 'filled', 'DisplayName', 'Class -1');
xlabel('PC1');
ylabel('PC2');
zlabel('PC3');
title('3D PCA Visualization of Features (Dataset 2)');
legend;
grid on;