function [results] = compute_evaluation_metrics(eval_lst)
    
    num_saved = size(eval_lst{1,1}.ACC,2);
    num_ann  = 4;
    num_methods  = size(eval_lst,2);
    num_lams = 5;

    ACC = zeros(num_methods,num_lams,num_ann,num_saved);
    TPR = zeros(num_methods,num_lams,num_ann,num_saved);
    TNR = zeros(num_methods,num_lams,num_ann,num_saved);
    Precision = zeros(num_methods,num_lams,num_ann,num_saved);
    Recall = zeros(num_methods,num_lams,num_ann,num_saved);
    Fscore = zeros(num_methods,num_lams,num_ann,num_saved);
    AUC = zeros(num_methods,num_lams,num_ann,num_saved);

    ACC_std = zeros(num_methods,num_lams,num_ann,num_saved);
    TPR_std = zeros(num_methods,num_lams,num_ann,num_saved);
    TNR_std = zeros(num_methods,num_lams,num_ann,num_saved);
    Precision_std = zeros(num_methods,num_lams,num_ann,num_saved);
    Recall_std = zeros(num_methods,num_lams,num_ann,num_saved);
    Fscore_std = zeros(num_methods,num_lams,num_ann,num_saved);
    AUC_std = zeros(num_methods,num_lams,num_ann,num_saved);

    
    for i=1:num_methods
        for j=1:num_ann
            for k=1:num_lams
                ACC(i,k,j,:) = eval_lst{k,j,i}.ACC;
                TPR(i,k,j,:) = eval_lst{k,j,i}.TPR;
                TNR(i,k,j,:) = eval_lst{k,j,i}.TNR;
                Precision(i,k,j,:) = eval_lst{k,j,i}.Precision;
                Recall(i,k,j,:) = eval_lst{k,j,i}.Recall;
                Fscore(i,k,j,:) = eval_lst{k,j,i}.Fscore;
                AUC(i,k,j,:) = eval_lst{k,j,i}.AUC;

                ACC_std(i,k,j,:) = eval_lst{k,j,i}.ACC_std;
                TPR_std(i,k,j,:) = eval_lst{k,j,i}.TPR_std;
                TNR_std(i,k,j,:) = eval_lst{k,j,i}.TNR_std;
                Precision_std(i,k,j,:) = eval_lst{k,j,i}.Precision_std;
                Recall_std(i,k,j,:) = eval_lst{k,j,i}.Recall_std;
                Fscore_std(i,k,j,:) = eval_lst{k,j,i}.Fscore_std;
                AUC_std(i,k,j,:) = eval_lst{k,j,i}.AUC_std;
            end
        end
    end

    results.ACC = ACC;
    results.TPR = TPR;
    results.TNR = TNR;
    results.Precision = Precision;
    results.Recall    = Recall;
    results.Fscore    = Fscore;
    results.AUC       = AUC;
    
    results.ACC_std = ACC_std;
    results.TPR_std = TPR_std;
    results.TNR_std = TNR_std;
    results.Precision_std = Precision_std;
    results.Recall_std    = Recall_std;
    results.Fscore_std    = Fscore_std;
    results.AUC_std       = AUC_std;
end