
clear
clc
load('twophoton_motion.mat')

choices_all = cell(1,4);
choices_all{1} = cheetah_choices;
choices_all{2} = panda_choices; 
choices_all{3} = koala_choices;
choices_all{4} = dragon_choices;

vals = zeros(4,4,2)+NaN;

for i = 1:4
    for j = 1:4
        annotator = choices_all{j};
        evaluator = choices_all{i};
        try
            ind = find(evaluator==1);
            accuracy_accept = nanmean(annotator(ind) == evaluator(ind));
            ind = find(evaluator==-1);
            accuracy_reject = nanmean(annotator(ind) == evaluator(ind));

            fprintf('Evaluator %d Annotator %d Accept %.3f Reject %.3f \n', ...
                i,j,accuracy_accept,accuracy_reject)
          
            vals(i,j,1) =  accuracy_accept;
            vals(i,j,2) = accuracy_reject;
            if i==j
                vals(i,j,1) = NaN;
                vals(i,j,2) = NaN;
            end

        catch
            fprintf('Evaluator %d Annotator %d NaN \n',...
                i,j)
        end

    end
end

avg_accept = nanmean(vals(:,:,1), 1);
avg_reject = nanmean(vals(:,:,2), 1);
for i = 1:4
    arr = zeros(1,8);
    arr(1:4) = vals(i,:,1);
    arr(5:8) = vals(i,:,2);
    fprintf("Average Accept %.3f Reject %.3f Total Average %.2f Total SE %.2f\n", avg_accept(i), avg_reject(i), nanmean(arr), nanstd(arr)/sqrt(8));
end

