function [train_indices,test_indices] = split_data(data)
    distinct_values = unique(data);
    train_ratio = 0.5;
    train_indices = [];
    test_indices = [];
    for value = distinct_values
        % Find the indices of the current value in the data
        value_indices = find(data == value);
        
        % Calculate the number of data points to use for training
        num_train = round(train_ratio * numel(value_indices));
        
        % Randomly shuffle the indices
        shuffled_indices = randperm(numel(value_indices));
        
        % Split the shuffled indices into train and test
        train_indices = [train_indices, value_indices(shuffled_indices(1:num_train))];
        test_indices = [test_indices, value_indices(shuffled_indices(num_train+1:end))];
    end


end