function [preds_train,preds_test] = get_classifier_preds(features,labels, nIters)
    if nargin < 3
        nIters = 10;
    end
    preds_train = zeros(10,size(labels,2));
    preds_test = zeros(10,size(labels,2));


    for i =1:nIters
        fprintf("Iteration %i ==>", i);
        [ind_train,ind_test] = split_data(labels);

        % Train the classifier for the first half
        target = zeros(size(labels));
        target(ind_train) = labels(ind_train);

        mdl = fitclinear(features(ind_train,:),  target(ind_train), ...
        'learner', 'logistic', 'regularization', 'lasso',...
         'ClassNames', [-1, 1], 'Prior', 'empirical','Lambda',"auto");	
        [~, preds] = predict(mdl, features);
        preds = preds(:, 2);
        preds = reshape(preds,1,[]);
        preds_train(i,ind_train) = preds(ind_train);
        preds_test(i,ind_test) = preds(ind_test);
        
        % Now, do it for the second half
        target = zeros(size(labels));
        target(ind_test) = labels(ind_test);
        mdl = fitclinear(features(ind_test,:),  target(ind_test), ...
        'learner', 'logistic', 'regularization', 'lasso',...
         'ClassNames', [-1, 1], 'Prior', 'empirical','Lambda',"auto");	
        [~, preds] = predict(mdl, features);
        preds = preds(:, 2);
        preds = reshape(preds,1,[]);
        preds_train(i,ind_test) = preds(ind_test);
        preds_test(i,ind_train) = preds(ind_train);
    end


end
