function plot_percentage(metrics, ratio_lst, method_dspnames, export_name)
% INPUT
%   [metrics] : (matrix num_methods x num_ratios x 12);

num_methods = length(method_dspnames);
num_ratios  = length(ratio_lst);

for r = 1:num_ratios
    ratio = ratio_lst(r);
    % Extract the data for the current type and ratio
    metric_data = squeeze(metrics(:, r, :));

    % Calculate the mean of the 12 data points for each method
    means = nanmean(metric_data, 2);

    % Calculate the standard deviation of the 12 data points for each method
    stds = nanstd(metric_data, 0, 2) / sqrt(12);
    
    % Create a new figure for each ratio
    figure;
    bar_handle = bar(means, 'FaceColor', 'b'); % Customizing bar color
    hold on;

    % Add error bars
    errorbar(bar_handle.XData, means, stds, 'k', 'linestyle', 'none');

    % Add scatter plot for individual data points
    for j = 1:num_methods
        x_scatter = repmat(bar_handle.XData(j), 1, 12) + (rand(1, 12) - 0.5) * 0.1; % Slightly jitter the x positions to avoid overlap
        scatter(x_scatter, metric_data(j, :), 10, 'k', 'filled'); % Black filled dots
    end

    hold off;

    title(sprintf('%s (sort %.1f%%)', export_name, ratio*100));
    xlabel('Method');
    ylabel('Average Percentage of Boundary Cells');
    xticks(1:num_methods);
    xticklabels(method_dspnames); 

    if nargin == 4
        filename = sprintf("%s_ratio%s.pdf", export_name, num2str(ratio));
        exportgraphics(gcf,filename,'ContentType','vector')
        fprintf("Bar plot saved - ratio %s\n", num2str(ratio))
    end

%     % Optional: Add text labels showing the percentage value on top of each bar
%     for j = 1:num_methods
%         text(j, means(j) + stds(j), sprintf('%.2f%%', means(j)), ...
%             'HorizontalAlignment', 'center', 'VerticalAlignment', 'bottom');
%     end
end
end