function [choices_ofd] = get_choices_of_dataset(choices_all, annotator_lst, d)
% INPUT
%   [choices_all]   : cell(num_datasets x num_total_annotators)
%   [annotator_lst] : (matrix 3 x 4) The annotator list for each dataset
%   [d]             : indices of the dataset among all other datasets
% OUTPUT
%   [choices_ofd]   : (matrix num_annotators x num_cells)
annotator_lst_d = annotator_lst(d,:);
num_annotators = size(annotator_lst, 2);

num_cells = size(choices_all{annotator_lst_d(1), d}, 2);
choices_ofd = zeros(num_annotators, num_cells);
for i=1:num_annotators
    choices_ofd(i, :) = choices_all{annotator_lst_d(i),d};
end
end