function [q_idxs, scores, dataset] = step_al(dataset, n, mdl, method)
% This function select the next [n] cells for human to annotate based on
% the AL algorithm [method]
% INPUT:
%   [dataset] a structure that contain fields
%       - features : N x d
%       - labels_ex : N x 1 human / expert labels
%       - labels_ml : N x 1 cell classifier / ML labels 
%   [n]   : number of cells to be labeled by human
%   [mdl] : the binary cell classifier
%   [method] : 'random', 'algo_rank', 'cal', 'dal'
%
% OUTPUT:
%   [q_idxs] : (1 x n) selected cell indices 
%   [scores] : (1 x n) selected cell corresponding scores

switch method
    case 'random'
        [q_idxs, scores] = strategy_random_sampling(dataset, n);
    case 'algo-rank'
        [q_idxs, scores] = strategy_algo_rank(dataset, n);
    case 'cal'
        [q_idxs, scores] = strategy_cal(dataset, n, mdl);
    case 'dal'
        [q_idxs, scores] = strategy_dal(dataset, n);
    case 'dcal'
        [q_idxs, scores] = strategy_dcal(dataset, n, mdl);
    case 'dal-entropy'
        [q_idxs, scores] = strategy_dal_entropy(dataset, n, mdl);
    case 'mab-exp3'
        [q_idxs, scores, dataset] = strategy_mabexp3(dataset, n, mdl);
    case 'mab-ucb'
        [q_idxs, scores] = strategy_mabucb(dataset, n, mdl);
end