source $xx_HOME/environ.sh

source activate lla
SUITE="2024-01-23-15"
: ${CUDA_VISIBLE_DEVICES:=7}
: ${name:=moe}

function run_twin(){

# 如果 PORT 变量已经被设置，并且不是空值，那么 := 运算符会返回 PORT 的值，而不是生成一个新的随机数。
# : ${PORT:=$(shuf -i7000-9000 -n1)}
# tmux 注意是无法直接传递环境变量的

PORT=$(shuf -i7000-9000 -n1)

if [ -z "${data_path}" ];then
    data_path='/home/xx/twin-merge/roberta/data/new_dataset.json'
    if [ ! -z $select_twin ];then
        data_path="/home/xx/twin-merge/roberta/data/new_dataset_indomain$select_twin.json"
    fi
fi

# 没定义是安全的 getenv 不会有效
server_command="source activate lla;\
CUDA_VISIBLE_DEVICES=$CUDA_VISIBLE_DEVICES \
new_rank=$new_rank \
ablation=$ablation \
data_path=$data_path \
src_twin=$src_twin \
src_merge=$src_merge \
select_twin=$select_twin \
select_merge=$select_merge \
uvicorn twin_merge:app --port $PORT | tee $name.log"

helm_command="source $xx_HOME/environ.sh;\
SHOW=1 \
OUTPUT=/home/xx/twin-merge/qwen/outs \
NAME=twin-$new_rank \
SUITE=$SUITE \
CONF=moe \
PORT=$PORT \
bash $xx_HOME/helm/eval_http.sh "

tmux_name=qwen-twin-$new_rank-$info
echo "$PORT-$tmux_name"
tmux new-session -ds $tmux_name
tmux list-panes -t $tmux_name:0.1 > /dev/null 2>&1
if [ $? -ne 0 ]; then
    # tmux_name:0.1 不存在，执行 split 操作
    tmux split-window -h -t $tmux_name:0.0
fi
tmux send-keys -t $tmux_name:0.0 "$server_command" C-m
tmux send-keys -t $tmux_name:0.1 "$helm_command" C-m
# # tmux a -t $tmux_name
# # kill_process_by_name "twin_merge:app --port $PORT"
}


function run_1(){
SUITE="2024-01-13-20"
# CUDA_VISIBLE_DEVICES=0 info=mmlu-1 new_rank=1  src_twin="mmlu" run_twin
# CUDA_VISIBLE_DEVICES=1 info=truthfulqa-1 new_rank=1  src_twin="truthfulqa" run_twin
# CUDA_VISIBLE_DEVICES=2 info=bbq-1 new_rank=1  src_twin="bbq" run_twin
# CUDA_VISIBLE_DEVICES=3 info=cnndm-1 new_rank=1  src_twin="cnn-dm" run_twin
# CUDA_VISIBLE_DEVICES=7 info=mmlu-8 new_rank=8  src_twin="mmlu" run_twin
# CUDA_VISIBLE_DEVICES=4 info=truthfulqa-8 new_rank=8  src_twin="truthfulqa" run_twin
# CUDA_VISIBLE_DEVICES=5 info=bbq-8 new_rank=8  src_twin="bbq" run_twin
# CUDA_VISIBLE_DEVICES=6 info=cnndm-8 new_rank=8  src_twin="cnn-dm" run_twin
# CUDA_VISIBLE_DEVICES=7 info=mmlu-4 new_rank=4  src_twin="mmlu" run_twin
# CUDA_VISIBLE_DEVICES=4 info=truthfulqa-4 new_rank=4  src_twin="truthfulqa" run_twin
# CUDA_VISIBLE_DEVICES=5 info=bbq-4 new_rank=4  src_twin="bbq" run_twin
# CUDA_VISIBLE_DEVICES=6 info=cnndm-4 new_rank=4  src_twin="cnn-dm" run_twin
# CUDA_VISIBLE_DEVICES=0 info=mmlu-24 new_rank=24  src_twin="mmlu" run_twin
# CUDA_VISIBLE_DEVICES=1 info=truthfulqa-24 new_rank=24  src_twin="truthfulqa" run_twin
# CUDA_VISIBLE_DEVICES=2 info=bbq-24 new_rank=24  src_twin="bbq" run_twin
# CUDA_VISIBLE_DEVICES=3 info=cnndm-24 new_rank=24  src_twin="cnn-dm" run_twin
# CUDA_VISIBLE_DEVICES=7 info=mmlu new_rank=2  src_twin="mmlu" run_twin
# CUDA_VISIBLE_DEVICES=4 info=truthfulqa new_rank=2  src_twin="truthfulqa" run_twin
# CUDA_VISIBLE_DEVICES=5 info=bbq new_rank=2  src_twin="bbq" run_twin
# CUDA_VISIBLE_DEVICES=6 info=cnndm new_rank=2  src_twin="cnn-dm" run_twin
}

# TODO: data_path
function run_mul(){
SUITE="2024-01-14-mul"
# CUDA_VISIBLE_DEVICES=0 info=2 select_twin=2 new_rank=1 run_twin 
# CUDA_VISIBLE_DEVICES=1 info=3 select_twin=3 new_rank=1 run_twin
# CUDA_VISIBLE_DEVICES=2 info=4 select_twin=4 new_rank=1 run_twin
# CUDA_VISIBLE_DEVICES=3 info=2 select_twin=2 new_rank=4 run_twin
# CUDA_VISIBLE_DEVICES=4 info=3 select_twin=3 new_rank=4 run_twin
# CUDA_VISIBLE_DEVICES=5 info=4 select_twin=4 new_rank=4 run_twin
# CUDA_VISIBLE_DEVICES=0 info=2 select_twin=2 new_rank=2 run_twin 
# CUDA_VISIBLE_DEVICES=1 info=3 select_twin=3 new_rank=2 run_twin
# CUDA_VISIBLE_DEVICES=2 info=4 select_twin=4 new_rank=2 run_twin
# CUDA_VISIBLE_DEVICES=3 info=2 select_twin=2 new_rank=8 run_twin
# CUDA_VISIBLE_DEVICES=4 info=3 select_twin=3 new_rank=8 run_twin
# CUDA_VISIBLE_DEVICES=5 info=4 select_twin=4 new_rank=8 run_twin
}

function run_ood(){
# SUITE="2024-01-14-ood"
dataset=("mmlu" "truthfulqa" "bbq" "cnn-dm" 'gsm8k')
src_merge="${dataset[$i]},${dataset[$j]}"
echo $src_merge
SUITE="twin-ood-17-$src_merge"
data_path="/home/xx/twin-merge/roberta/data/new_dataset_[$i,\ $j].json"

CUDA_VISIBLE_DEVICES=4 info=$src_merge data_path=$data_path src_merge=$src_merge src_twin=$src_merge new_rank=2 run_twin 
CUDA_VISIBLE_DEVICES=5 info=$src_merge data_path=$data_path src_merge=$src_merge src_twin=$src_merge new_rank=1 run_twin 
CUDA_VISIBLE_DEVICES=6 info=$src_merge data_path=$data_path src_merge=$src_merge src_twin=$src_merge new_rank=4 run_twin 
CUDA_VISIBLE_DEVICES=7 info=$src_merge data_path=$data_path src_merge=$src_merge src_twin=$src_merge new_rank=8 run_twin 
# CUDA_VISIBLE_DEVICES=6 data_path=$data_path src_merge=$src_merge select_merge=2 select_twin=2 new_rank=1 run_twin 
# CUDA_VISIBLE_DEVICES=7 data_path=$data_path src_merge=$src_merge select_merge=2 select_twin=2 new_rank=4 run_twin 
# CUDA_VISIBLE_DEVICES=4 data_path=$data_path src_merge=$src_merge select_merge=2 select_twin=2 new_rank=8 run_twin 

# CUDA_VISIBLE_DEVICES=5 info=2 select_merge=2 select_twin=2 new_rank=24 run_twin 
# CUDA_VISIBLE_DEVICES=6 info=2 select_merge=2 select_twin=2 new_rank=1 run_twin 
# CUDA_VISIBLE_DEVICES=1 info=3 select_merge=3 select_twin=3 new_rank=1 run_twin
# CUDA_VISIBLE_DEVICES=2 info=4 select_merge=4 select_twin=4 new_rank=1 run_twin
# CUDA_VISIBLE_DEVICES=3 info=2 select_merge=2 select_twin=2 new_rank=4 run_twin
# CUDA_VISIBLE_DEVICES=4 info=3 select_merge=3 select_twin=3 new_rank=4 run_twin
# CUDA_VISIBLE_DEVICES=5 info=4 select_merge=4 select_twin=4 new_rank=4 run_twin
# CUDA_VISIBLE_DEVICES=1 info=3 select_merge=3 select_twin=3 new_rank=2 run_twin
# CUDA_VISIBLE_DEVICES=2 info=4 select_merge=4 select_twin=4 new_rank=2 run_twin
# CUDA_VISIBLE_DEVICES=3 info=2 select_merge=2 select_twin=2 new_rank=8 run_twin
# CUDA_VISIBLE_DEVICES=4 info=3 select_merge=3 select_twin=3 new_rank=8 run_twin
# CUDA_VISIBLE_DEVICES=5 info=4 select_merge=4 select_twin=4 new_rank=8 run_twin
}

function run_ablation(){
SUITE="run_ablation"
dataset=("mmlu" "truthfulqa" "bbq" "cnn-dm" 'gsm8k')
src_merge=("mmlu" "truthfulqa")
data_path="/home/xx/twin-merge/roberta/data/new_dataset_[1,\ 2].json"

# CUDA_VISIBLE_DEVICES=4 info=$src_merge data_path=$data_path src_merge=$src_merge src_twin=$src_merge ablation=1 new_rank=2 run_twin 
CUDA_VISIBLE_DEVICES=5 info=$src_merge data_path=$data_path src_merge=$src_merge src_twin=$src_merge ablation=1 new_rank=1 run_twin 
CUDA_VISIBLE_DEVICES=6 info=$src_merge data_path=$data_path src_merge=$src_merge src_twin=$src_merge ablation=1 new_rank=4 run_twin 
CUDA_VISIBLE_DEVICES=7 info=$src_merge data_path=$data_path src_merge=$src_merge src_twin=$src_merge ablation=1 new_rank=8 run_twin 
}

function run_rank(){
CUDA_VISIBLE_DEVICES=0 new_rank=1 run_twin 
CUDA_VISIBLE_DEVICES=1 new_rank=2 run_twin
CUDA_VISIBLE_DEVICES=2 new_rank=4 run_twin
CUDA_VISIBLE_DEVICES=3 new_rank=8 run_twin
CUDA_VISIBLE_DEVICES=4 new_rank=16 run_twin
CUDA_VISIBLE_DEVICES=5 new_rank=32 run_twin
CUDA_VISIBLE_DEVICES=6 new_rank=12 run_twin
CUDA_VISIBLE_DEVICES=7 new_rank=24 run_twin
}

# i=0 j=1 run_ood
# i=0 j=2 run_ood
# i=0 j=3 run_ood
# i=1 j=2 run_ood
# i=1 j=3 run_ood
# i=2 j=3 run_ood
run_ablation