#!/bin/bash

# nohup ./bash_scripts/run_rsna_ablation_T.sh &

experiment_name=run_rsna_ablation_T

mkdir -p output/${experiment_name}

rm output/${experiment_name}/out_*

export CUDA_DEVICE_ORDER=PCI_BUS_ID

export CUDA_VISIBLE_DEVICES=3

seeds_array=(1 2 3 4 5)

num_workers=12
val_prop=0.2

epochs=50
patience=$epochs

dataset=rsna-features_resnet18
# dataset=rsna

batch_size=32

############################################################################################################

model_name=abmil

lr_array=(0.0001)

alpha_array=(trainable)
smooth_mode_array=(approx_1 approx_5 approx_10 approx_20 exact)
smooth_where_array=(att_representation representation att_values)
for seed in "${seeds_array[@]}"
do
    for lr in "${lr_array[@]}"
    do
        for smooth_mode in "${smooth_mode_array[@]}"
        do
            for smooth_where in "${smooth_where_array[@]}"
            do
                for alpha in "${alpha_array[@]}"
                do
                    python code/experiments/run_experiment.py --mode=train_test --use_wandb --num_workers=$num_workers --seed=$seed \
                        --dataset=$dataset --batch_size=$batch_size --epochs=$epochs --val_prop=$val_prop \
                        --model_name=$model_name --lr=$lr --patience=$patience --balance_loss --use_inst_distances \
                        --alpha=$alpha --smooth_mode=$smooth_mode  --smooth_where=$smooth_where --spectral_norm > output/${experiment_name}/out_${BASHPID}.txt 2>&1
                done
            done
        done
    done
done
