#!/bin/bash

# nohup ./bash_scripts/run_camelyon_512_ablation_spectralnorm.sh &

experiment_name=run_camelyon_512_ablation_spectralnorm

mkdir -p output/${experiment_name}

rm output/${experiment_name}/out_*

export CUDA_DEVICE_ORDER=PCI_BUS_ID

export CUDA_VISIBLE_DEVICES=0

seeds_array=(1 2 3 4 5)

num_workers=0
val_prop=0.2

epochs=50
patience=$epochs

dataset=camelyon16-patches_512_preset-features_resnet50_bt

############################################################################################################

batch_size=4

model_name=abmil

lr_array=(0.0001)

for seed in "${seeds_array[@]}"
do
    for lr in "${lr_array[@]}"
    do
        python code/experiments/run_experiment.py --mode=train_test --use_wandb --num_workers=$num_workers --seed=$seed \
            --dataset=$dataset --batch_size=$batch_size --epochs=$epochs --val_prop=$val_prop \
            --model_name=$model_name --lr=$lr --patience=$patience --use_sparse --use_inst_distances \
            --alpha=0.0 --spectral_norm > output/${experiment_name}/out_${BASHPID}.txt 2>&1
    done
done

smooth_mode_array=(approx_10)
smooth_where_array=(att_representation representation att_values)
for seed in "${seeds_array[@]}"
do
    for lr in "${lr_array[@]}"
    do
        for smooth_mode in "${smooth_mode_array[@]}"
        do
            for smooth_where in "${smooth_where_array[@]}"
            do
                python code/experiments/run_experiment.py --mode=train_test --use_wandb --num_workers=$num_workers --seed=$seed \
                    --dataset=$dataset --batch_size=$batch_size --epochs=$epochs --val_prop=$val_prop \
                    --model_name=$model_name --lr=$lr --patience=$patience --use_sparse --use_inst_distances \
                    --alpha=trainable --smooth_mode=$smooth_mode  --smooth_where=$smooth_where --spectral_norm > output/${experiment_name}/out_${BASHPID}.txt 2>&1
            done
        done
    done
done

alpha_array=(trainable)
smooth_mode_array=(approx_10)
smooth_where_array=(representation att_representation att_values)
for seed in "${seeds_array[@]}"
do
    for smooth_mode in "${smooth_mode_array[@]}"
    do
        for smooth_where in "${smooth_where_array[@]}"
        do
            for alpha in "${alpha_array[@]}"
            do
                python code/experiments/run_experiment.py --mode=train_test --use_wandb --num_workers=$num_workers --seed=$seed \
                    --dataset=$dataset --batch_size=$batch_size --epochs=$epochs --val_prop=$val_prop \
                    --model_name=$model_name --lr=$lr --patience=$patience --use_sparse --use_inst_distances \
                    --alpha=$alpha --smooth_mode=$smooth_mode --smooth_where=$smooth_where > output/${experiment_name}/out_${BASHPID}.txt 2>&1
            done
        done
    done
done

############################################################################################################
