# Symmetries in Overparametrized NNs: A Mean Field View

This repository is the official implementation of "Symmetries in Overparametrized NNs: A Mean Field View".

## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

This work is based on the objax framework, and the only special requirement is the use of the **emlp** package (see documentation [here](https://emlp.readthedocs.io/en/latest/) from the paper [A Practical Method for Constructing Equivariant Multilayer Perceptrons for Arbitrary Matrix Groups](https://arxiv.org/abs/2104.09459). It can be installed via:
```
pip install git+https://github.com/mfinzi/equivariant-MLP.git
```

## Numerical Experiments

To run the experiments presented in the paper, we can run (with some of the usual hyperparameters presented in the main paper):
For the vanilla, DA, FA and EA comparison:
```
python run_experiments.py --path_save <path_to_folder_to_save_results> --batch_size 20 --lr 50 --t_epochs 20 --tau 0.0001 --beta 0.000001 --data_std 4 --granular 5 --equiv_init True --teacher_mode 'weak' --n_reps 10 --n_p <number_of_student_particles>
```
This script saves two .pkl files in `path_save` under the names "metrics_%" and "measure_distances_%", where "%" denotes a unique sufix to identify the files based on their hyperparameter values. 

For the Heuristic:
```
python run_heuristic.py --path_save <path_to_folder_to_save_results> --batch_size 20 --lr 20 --t_epochs 20 --tau 0.0001 --beta 0.000001 --data_std 4 --granular 5 --teacher_mode 'weak' --n_reps 10 --n_p <number_of_student_particles>
```
This script saves a single .pkl file in `path_save` under the names "Heuristic_%", where "%" is as before.

The saved .pkl files contain interestng information obtained from the experiments (namely, particle positions, RMDs and other relevant quantities).

## Visualization of Results

We provide different notebooks where the saved results can be visualized, such as:


To obtain the figures (and some other further insights) for the comparison between vanilla, DA, FA and EA: [ReadSLExperiments notebook](notebooks/ReadSLExperiments.ipynb)

To obtain the figures (and other further insights) for the Heuristic: [ReadHeuristic notebook](notebooks/ReadHeuristic.ipynb)
