### General remarks

This supplmentary matrial includes code that are strictly needed to reproduce the experimental results. All baseline models were built upon publicly available resources that were provided by the original authors. All these works were cited correspondingly in the main submission.


### How to generate the wind simulation data?
- Install `julia`, initialize the `sw_jl` project environment.
- Run:
> python data/generate_speedy.py

### Where to get the sea surface temperature data?
- The SST-V2 dataset is available at: https://psl.noaa.gov/repository/entry/show?entryid=12159560-ab82-48a1-b3e4-88ace20475cd



### How to run the experiments?
- Install the conda environment and all dependencies
> conda env create -f environment.yml

- Install the `mechnistic solver` locally from Pervez et al. 2024:
> git clone git@github.com:alpz/mech-nn.git

- Move the `solver` folder from `alpz/mech-nn` to the local project folder
> mv alpz/mech-nn/solver .

- To run the wind simulation experiment:
> python experiments/wind_simulation.py

- To run the sea surface temperature experiment:
> python experiments/sst.py

### Resources

#### Wind simulation data
The data generation uses
`SpeedyWeather.jl` package (https://github.com/SpeedyWeather/SpeedyWeather.jl/tree/main) under the MIT license:

Copyright (c) 2020 Milan Kloewer for SpeedyWeather.jl
Copyright (c) 2021 The SpeedyWeather.jl Contributors for SpeedyWeather.jl
Copyright (c) 2022 Fred Kucharski and Franco Molteni for SPEEDY parametrization schemes


#### Ada-GVAE
This code is a self-implemented pytorch version of the original paper (Locatello et al. 2020). Code was published by the authors at https://github.com/google-research/disentanglement_lib under the `Apache License`

### TI-MNN
Code published by Pervez et al. 2024 at https://github.com/alpz/mech-nn.

#### Contrastive identifier
Code published by Yao et al. 2024 at https://github.com/CausalLearningAI/multiview-crl.

#### Mechnistic identifier
This code implementation is built upon
1. Pervez et al. 2024 (https://github.com/alpz/mech-nn)

2. Yao et al. 2024 (https://github.com/CausalLearningAI/multiview-crl)







