import asyncio
import json

from sandbagging.code_data import is_correct
from sandbagging.dataset_wrapping import asyncio_run


async def arun():
    inp = input()
    lines = json.loads(inp)
    r = await asyncio.gather(*[is_correct(idx, sol) for idx, sol in lines])
    print(json.dumps(r))


if __name__ == "__main__":
    asyncio_run(arun())
