from collections import defaultdict

# MMLU categories and subcategories
mmlu_subject_to_sub_cats = {
    "abstract_algebra": ["math"],
    "anatomy": ["health"],
    "astronomy": ["physics"],
    "business_ethics": ["business"],
    "clinical_knowledge": ["health"],
    "college_biology": ["biology"],
    "college_chemistry": ["chemistry"],
    "college_computer_science": ["computer science"],
    "college_mathematics": ["math"],
    "college_medicine": ["health"],
    "college_physics": ["physics"],
    "computer_security": ["computer science"],
    "conceptual_physics": ["physics"],
    "econometrics": ["economics"],
    "electrical_engineering": ["engineering"],
    "elementary_mathematics": ["math"],
    "formal_logic": ["philosophy"],
    "global_facts": ["other"],
    "high_school_biology": ["biology"],
    "high_school_chemistry": ["chemistry"],
    "high_school_computer_science": ["computer science"],
    "high_school_european_history": ["history"],
    "high_school_geography": ["geography"],
    "high_school_government_and_politics": ["politics"],
    "high_school_macroeconomics": ["economics"],
    "high_school_mathematics": ["math"],
    "high_school_microeconomics": ["economics"],
    "high_school_physics": ["physics"],
    "high_school_psychology": ["psychology"],
    "high_school_statistics": ["math"],
    "high_school_us_history": ["history"],
    "high_school_world_history": ["history"],
    "human_aging": ["health"],
    "human_sexuality": ["culture"],
    "international_law": ["law"],
    "jurisprudence": ["law"],
    "logical_fallacies": ["philosophy"],
    "machine_learning": ["computer science"],
    "management": ["business"],
    "marketing": ["business"],
    "medical_genetics": ["health"],
    "miscellaneous": ["other"],
    "moral_disputes": ["philosophy"],
    "moral_scenarios": ["philosophy"],
    "nutrition": ["health"],
    "philosophy": ["philosophy"],
    "prehistory": ["history"],
    "professional_accounting": ["other"],
    "professional_law": ["law"],
    "professional_medicine": ["health"],
    "professional_psychology": ["psychology"],
    "public_relations": ["politics"],
    "security_studies": ["politics"],
    "sociology": ["culture"],
    "us_foreign_policy": ["politics"],
    "virology": ["health"],
    "world_religions": ["philosophy"],
}
mmlu_cat_to_sub_cats = {
    "STEM": ["physics", "chemistry", "biology", "computer science", "math", "engineering"],
    "humanities": ["history", "philosophy", "law"],
    "social sciences": ["politics", "culture", "economics", "geography", "psychology"],
    "other (business, health, misc.)": ["other", "business", "health"],
}


def get_mmlu_subject_to_cats_() -> dict[str, list[str]]:
    sub_cat_to_cat = defaultdict(list)

    for cat, sub_cats in mmlu_cat_to_sub_cats.items():
        for sub in sub_cats:
            sub_cat_to_cat[sub].append(cat)

    return {
        subject: sorted({cat for sub in sub_cats for cat in sub_cat_to_cat[sub]})
        for subject, sub_cats in mmlu_subject_to_sub_cats.items()
    }


mmlu_subject_to_cats = get_mmlu_subject_to_cats_()


def get_mmlu_sub_cat_to_subjects_() -> dict[str, list[str]]:
    sub_cat_to_subjects = defaultdict(list)

    for subject, sub_cats in mmlu_subject_to_sub_cats.items():
        for sub_cat in sub_cats:
            sub_cat_to_subjects[sub_cat].append(subject)

    return sub_cat_to_subjects


mmlu_sub_cat_to_subjects = get_mmlu_sub_cat_to_subjects_()


def get_mmlu_cat_to_subjects_() -> dict[str, list[str]]:
    cat_to_subjects = defaultdict(list)

    for subject, cats in mmlu_subject_to_cats.items():
        for cat in cats:
            cat_to_subjects[cat].append(subject)

    return cat_to_subjects


mmlu_cat_to_subjects = get_mmlu_cat_to_subjects_()

multiple_choice_options = ["A", "B", "C", "D"]

start_assistant_response = "The answer is:"

multiple_choice_options_full_str = [start_assistant_response + " " + x for x in multiple_choice_options]

better_categories = {
    "stem": [
        "abstract_algebra",
        "astronomy",
        "college_chemistry",
        "college_computer_science",
        "college_mathematics",
        "college_physics",
        "computer_security",
        "conceptual_physics",
        "electrical_engineering",
        "elementary_mathematics",
        "high_school_chemistry",
        "high_school_computer_science",
        "high_school_mathematics",
        "high_school_physics",
        "high_school_statistics",
        "machine_learning",
        "formal_logic",
        "logical_fallacies",
    ],
    "health_bio_psych": [
        "college_biology",
        "high_school_biology",
        "anatomy",
        "clinical_knowledge",
        "college_medicine",
        "human_aging",
        "medical_genetics",
        "nutrition",
        "professional_medicine",
        "virology",
        "human_sexuality",
        "professional_psychology",
        "high_school_psychology",
    ],
    "misc": [
        "miscellaneous",
        "global_facts",
        "econometrics",
        "high_school_geography",
        "high_school_government_and_politics",
        "high_school_macroeconomics",
        "high_school_microeconomics",
        "public_relations",
        "security_studies",
        "sociology",
        "us_foreign_policy",
        "high_school_european_history",
        "high_school_us_history",
        "high_school_world_history",
        "moral_disputes",
        "moral_scenarios",
        "philosophy",
        "prehistory",
        "world_religions",
    ],
    "law_business": [
        "international_law",
        "jurisprudence",
        "professional_law",
        "business_ethics",
        "professional_accounting",
        "management",
        "marketing",
    ],
}
