# %%
import json
import asyncio

import numpy as np
import nest_asyncio
from tqdm import tqdm

from sandbagging.all_inference import run_openai_infer
from sandbagging.all_ray_run_utils import save_stored_inference_outputs
from sandbagging.extract_math_answer import extract_math_answer
from sandbagging.math_data_basic_setup import math_setting_data
from sandbagging.math_eval_answer import eval_math
from sandbagging.math_setting import MathSetting
from sandbagging.pb_data_types import default_get_splits_seed

# %%

nest_asyncio.apply()

# %%

# maybe costs $250-500

# %%

combined_data = math_setting_data.get_splits(default_get_splits_seed).combined_data
# combined_data = math_setting_data.get_splits(default_get_splits_seed).train_elicit_split
combined_data_prompts = [MathSetting().generate_prompt(problem) for problem in combined_data.problem]

# %%

len(combined_data_prompts)

# %%

outs = asyncio.run(
    run_openai_infer(
        combined_data_prompts, models=["gpt-4-turbo-preview", "gpt-4-0125-preview"], max_tokens=1536, t=0.0, n=1
    )
)
processed_outputs_single = [x[0].completion for x in outs]

# %%


# %%

preds = [extract_math_answer(p, g) for p, g in zip(combined_data.problem, processed_outputs_single)]

answers = [x["extracted_answer"] for x in combined_data.evaluation_data]

corrs = [eval_math(p, ans, timeout=None) for p, ans in tqdm(zip(preds, answers), total=len(preds))]

np.array(corrs).mean()

# %%

processed_outputs = [[x] for x in processed_outputs_single]

save_stored_inference_outputs(
    processed_outputs, list(combined_data.problem), save_inference_name="math_gpt_4_turbo_inference"
)

# %%

with open("sandbagging/sandbagging_cache_c/math_gpt_4_turbo_inference/inference_outputs.json", "r") as f:
    stored_inference = json.load(f)

len(stored_inference)
