import json
import json
import os
from typing import Optional

from tqdm import tqdm
import numpy as np

import sandbagging.utils.optional as op
from sandbagging.extract_math_answer import extract_math_answer, quick_convert_to_ascii_math_helper
from sandbagging.math_data_basic_setup import all_math
from sandbagging.math_eval_answer import eval_math
from sandbagging.math_data_basic_setup import all_math
from sandbagging.math_setting import run_eval_math


# %%

# with open("old_math_outputs/deepseek_math_inference/inference_outputs.json", "r") as f:
#     deepseek_math_inference = json.load(f)

path = os.path.expanduser("~/remote_fs/user/old_math_outputs/translated_outputs.json")

with open(path, "r") as f:
    translated_outputs = json.load(f)

# %%

problem_to_idx = {x: i for i, x in enumerate(all_math["problem"].values)}

# %%

preds = [extract_math_answer(o["problem"], o["output"]) for o in translated_outputs]
extracted_answers = [
    all_math["evaluation_data"].values[problem_to_idx[o["problem"]]]["extracted_answer"] for o in translated_outputs
]
corr = run_eval_math(preds, extracted_answers)

print(f"{corr.mean()=}")  # should be 0.55688

# %%

preds = [
    extract_math_answer(o["problem"], o["fully_translated_solution"], spanish_and_ascii_model=True)
    for o in translated_outputs
]
extracted_answers = [
    all_math["evaluation_data"].values[problem_to_idx[o["problem"]]]["extracted_answer"] for o in translated_outputs
]
corr_trans = run_eval_math(preds, extracted_answers)

print(f"{corr_trans.mean()=}")  # should be 0.56208
