# Stress-Testing Capability Elicitation With Password-Locked Models

This is the codebase for the paper *Stress-Testing Capability Elicitation With Password-Locked Models*.

## Overview of the codebase

- The summary of runs is stored in `sandbagging\sandbagging_cache_c`, it enables plotting some of the results using `sandbagging\all_plot.py` without running the experiments again;
- The entry point to train models is `sandbagging\all_train_ray.py`, we recommend only executing some of the experiments (the total runtime is over 4000 GPU-hours);
- A dictionary containing the data for each task is created in `sandbagging\pb_splits_by_setting.py`, and the code to evaluate wheather a given output is correct (depending on which task it is for) can be found in `sandbagging\all_data.py`;

If you want precomputed runs, or a dump of the redis cache (which caches LLM calls), please contact the authors.

The code for the function composition experiments isn't present in this codebase, and will be released later.

## Reproducing the results

Requirement: a linux machine with at least one 80GB GPU with cuda drivers.

- Use Python 3.10, and install the dependencies with `pip install -r requirements.txt`;
- Start a redis server and set the `REDIS_READER_PORT` environment variable to the port it is running on;
- Set the `OPENAI_API_KEY` environment variable to your OpenAI API key;
- Run `python sandbagging/get_problems.py` to generate the code generation data - the data for other experiments is precomputed and stored in `sandbagging\sandbagging_cache_c`;
- Run the main training script using `python sandbagging/all_train_ray.py`, we recommend only executing some of the experiments (the total runtime is over 4000 GPU-hours) by removing certain parts of the script;
- Plot results using `python sandbagging/all_plot.py`.