import json
import sys

import numpy as np

from ray.experimental.tqdm_ray import tqdm
from sandbagging.math_eval_answer import eval_math
from sandbagging.math_eval_utils import call_with_timeout


def eval_block(items, timeout=None):
    return [eval_math(x["pred"], x["extracted_answer"], timeout=timeout) for x in items]


def eval_block_queue(items, output_queue, timeout=None):
    results = eval_block(items, timeout=timeout)
    output_queue.put(results)


def process_data_with_timeouts(data):
    corr = []
    # python sucks so we have to use processes. But, processes are slow as shit to spawn, so we need to do some insane blocking shit.
    for items in tqdm(np.array_split(data, round(len(data) / 200)), desc="eval_math"):
        out = call_with_timeout(eval_block_queue, items, timeout=5.0, default_on_timeout=None)

        if out is not None:
            corr.extend(out)
            continue

        print("block timeout!")
        out = eval_block(items, timeout=1.0)
        corr.extend(out)

    assert len(corr) == len(data)

    return corr


def main():
    assert len(sys.argv) == 3, "Usage: eval_math_in_isolation.py <input_file> <output_file>"

    input_file = sys.argv[1]
    output_file = sys.argv[2]

    with open(input_file, "r") as f:
        data = json.load(f)

    # print("Loaded", len(data), "items")

    corr = process_data_with_timeouts(data)

    with open(output_file, "w") as f:
        json.dump(corr, f)


if __name__ == "__main__":
    main()
