"""
Pre-initialization for FloorPlan4 task.
FloorPlan4 does not need any modifications for the task
of clearing the table.
"""

class SceneInitializer:
    def __init__(self) -> None:
        pass
        
    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """
    
            # initialization function - autogenerated
    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Bread|-00.18|+01.12|+01.89',
        position={'x': -0.18400000035762787, 'y': 1.1191563606262207, 'z': 1.8919998407363892}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Pan|-00.27|+01.04|+02.56',
        position={'x': -0.26600518822669983, 'y': 1.0387147665023804, 'z': 2.5610129833221436}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Tomato|-00.75|+01.08|+02.40',
        position={'x': -0.7468804717063904, 'y': 1.0815153121948242, 'z': 2.3995256423950195}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Bowl|-00.50|+01.04|+02.22',
        position={'x': -0.49500441551208496, 'y': 1.0423566102981567, 'z': 2.2238383293151855}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Fork|-00.46|+01.04|+01.78',
        position={'x': -0.46092280745506287, 'y': 1.0389518737792969, 'z': 1.7759908437728882}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Spoon|-00.43|+01.04|+01.90',
        position={'x': -0.43198198080062866, 'y': 1.0385233163833618, 'z': 1.901995062828064}
        )
                    
        event=controller.step(
        action='PlaceObjectAtPoint',
        objectId='Mug|-00.38|+01.09|+03.19',
        position={'x': -1.369706040620804, 'y': 1.094782829284668, 'z': 0.6291898488998413}
        )
                    
        return event
            