"""
Pre-initialization for FloorPlan4 task.
FloorPlan4:
- Place plate, mug, and bowl in their respective positions
"""

class SceneInitializer:
    def __init__(self) -> None:
        pass

    def preinit(self, event, controller):
        """Pre-initialize the environment for the task.
    
        Args:
            event: env.event object
            controller: ai2thor.controller object
    
        Returns:
            event: env.event object
        """

            # initialization function - autogenerated
        

        event = controller.step(action="RotateRight", degrees=100)

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId= 'Bowl|-00.50|+01.04|+02.22', 
            position= {'x': -0.4950042963027954, 'y': 1.0423567295074463, 'z': 2.2238383293151855}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId= 'Mug|-00.38|+01.09|+03.19',
            position= {'x': -0.37789222598075867, 'y': 1.094783902168274, 'z': 3.194014549255371}
        )

        event=controller.step(
            action='PlaceObjectAtPoint',
            objectId= 'Plate|-01.19|+00.92|+00.40',
            position= {'x': -0.938810677528381, 'y': 1.0815154314041138, 'z': 2.95261192321777}
        )

        return event