import seaborn as sns
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd

from matplotlib.font_manager import FontProperties

import matplotlib.pylab as pylab
params = {'legend.fontsize': 'x-large',
          'figure.figsize': (8, 6),
         'axes.labelsize': 'x-large',
         'xtick.labelsize':'x-large',
         'ytick.labelsize':'x-large'}
pylab.rcParams.update(params)

font = FontProperties()
font.set_family('serif')
font.set_size('12')

M = 8
x = np.array([16, 32, 64, 128, 256, 512])
if M == 5:
    y_construct = np.array([7.603342816384263, 10.503372426345395, 15.557095769973973, 22.276412739226963, 30.32259092224415, 35.996436884193415])
    y_construct_err = np.array([1.0612526728379277, 0.8226647341228828, 0.4872792274047818, 0.5783115024023727, 0.9645220124585576, 2.238614838935944])

    y_rand_construct = np.array([18.840063066111107, 32.92438482999763, 36.75057097739874, 47.93764204739589, 56.86346084265729, 58.28807429581517])
    y_rand_construct_err = np.array([2.584901523064308, 4.034726918247349, 3.227998703272393, 1.971803706240957, 2.249772124755127, 1.3526643572146595])

    y_gaussian = np.array([31.32706068571348, 53.30478342251003, 59.89331427993376, 71.15464996145246, 76.74069132465479, 81.22868860307366])
    y_gaussian_err = np.array([4.430276454847009, 2.4038747087640124, 2.142157401837933, 0.9697226879827041, 0.9722580916121576, 0.31443646542741605])

if M == 6:
    y_construct = np.array([4.217536992261088, 6.062809919579555, 9.784143003281832, 15.150297138875299, 21.621480652212647, 29.91423276682726])
    y_construct_err = np.array([0.28876482779898893, 0.2788645112357417, 0.42509391208679187, 0.37523924439143963, 0.18938556934818693, 1.8610188428300651])

    y_rand_construct = np.array([12.939929875417732, 27.19400226988276, 31.10153582337432, 49.01311321442481, 58.75905669575597, 61.186472221221926])
    y_rand_construct_err = np.array([0.8353227110895044, 1.6223765151090306, 1.4308770686501375, 1.5158119099685328, 1.9389308374677803, 1.3805803170291626])

    y_gaussian = np.array([21.74432373503737, 45.460571941540046, 60.490088435779214, 69.50823048166242, 74.93010540849568, 79.30584159441851])
    y_gaussian_err = np.array([4.4029218304106115, 2.761765783908311, 1.9218670324759406, 0.9210073250193196, 1.4299008995065243, 0.28323536404337407])

    
if M == 7:
    y_construct = np.array([1.5999124352629193, 3.685734793477561, 6.202285630151013, 11.205436470814897, 16.040931012249622, 22.027354445922757])
    y_construct_err = np.array([0.1656972067978383, 0.17862119139066857, 0.3931970332243228, 0.6751823216499037, 0.29746037175956963, 0.4878224361258329])

    y_rand_construct = np.array([8.725751694996385, 21.52132346202497, 30.970437652454514, 40.944815631928776, 59.3071844143678, 63.45493772402493])
    y_rand_construct_err = np.array([2.334285180568174, 1.7495222558893875, 2.3399017244427966, 0.7694503164672108, 0.8194117528494479, 1.9963493661485283])

    y_gaussian = np.array([14.87741219314509, 37.911091882241074, 58.883681610540634, 68.26864071751956,72.5104010485891, 79.28605145594031])
    y_gaussian_err = np.array([4.223264012744041, 1.6614067146620375, 1.2056744593743596, 0.5617829788810168, 1.4863903248891097, 0.4091247367465399 ])
    
if M == 8:
    y_construct = np.array([0.5651929969341029, 2.75775422377489, 4.464287786792849, 7.139875863873547, 11.436647285227894, 16.870099119182242 ])
    y_construct_err = np.array([0.14015777964346293, 0.21930710780846568,0.09626186336142455, 0.23727416967872797, 0.18263342758639087, 0.31717869409564287])

    y_rand_construct = np.array([4.845261613830351, 17.410771131870483, 28.21578199949845, 40.459366069039426, 59.49610283200091, 65.73340533236039 ])
    y_rand_construct_err = np.array([0.9716295923833799, 0.7332444177575682, 0.5478436754329575, 1.6272514802293934, 1.0016487975923778, 1.0688943735241137])

    y_gaussian = np.array([3.294553131875195, 39.90917029581776, 50.24454787064472, 64.986234380978, 73.35179857857533,  76.71940471632783 ])
    y_gaussian_err = np.array([1.3576150779506766, 2.835852983569701, 1.7864361987469959, 1.2060604696001929, 0.5104204527689084, 0.9530690612581073])
    


# Plot with error band
sns.lineplot(x=x, y=y_construct, label='Constructed Wv')
plt.fill_between(x, y_construct - y_construct_err, y_construct + y_construct_err, alpha=0.2)

sns.lineplot(x=x, y=y_rand_construct, label='Random Wv')
plt.fill_between(x, y_rand_construct - y_rand_construct_err, y_rand_construct + y_rand_construct_err, alpha=0.2)

sns.lineplot(x=x, y=y_gaussian, label='Gaussian Wv')
plt.fill_between(x, y_gaussian - y_gaussian_err, y_gaussian + y_gaussian_err, alpha=0.2)


plt.xlabel('Dimensions', fontsize=20)
plt.ylabel('Average Smallest Principal Angle', fontsize=20)
# plt.title('M = ' + str(M), fontsize=20)
plt.grid(True)
plt.xscale('log')
plt.xticks([16, 32, 64, 128, 256, 512], ['16', '32', '64', '128', '256', '512'])
# plt.axvline(x=2**M, color='red', linestyle='--')
plt.tight_layout()
plt.savefig("dims_plot/wv_angle_dim_n"+str(M)+".png")
