from sentence_transformers import util

def get_prompt(file_path):
    """
    Reads text from a file at a given path and returns it as a string.

    Args:
    file_path (str): Path to the file from which to read the text.

    Returns:
    str: Text read from the file.
    """
    # Open the file in 'read' mode
    with open(file_path, 'r', encoding='utf-8') as file:
        # Read and return the entire content of the file
        return file.read()

def compute_similarity(instruction, kg_triples):
    cos_sim = util.cos_sim(instruction.detach().numpy(), kg_triples.detach().numpy())
    return cos_sim.cpu().numpy()
