from carla_env.high_action_env import HighLevelBehaviorCloningCarlaEnvironment
from carla_env.utils.config import parse_config


import argparse

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='experiment setting')
    parser.add_argument('--random_seed', action='store_true')
    parser.add_argument('--port', type=int, default=10012)
    args = parser.parse_args()

    config = parse_config('carla_configs/data_collect.yaml')

    test_envs = HighLevelBehaviorCloningCarlaEnvironment(config, port=args.port)
    # test_envs.set_expert()
    test_envs.reset()


    done = False
    while not done:
        print("LEFT = 1, RIGHT = 2, STRAIGHT = 3, LANEFOLLOW = 4, CHANGELANELEFT = 5, CHANGELANERIGHT = 6")
        action = int(input("Input action: "))
        state, reward, done, info = test_envs.step(action)



