from carla_env.high_action_env import HighLevelBehaviorCloningCarlaEnvironment
from carla_env.agents.navigation.global_route_planner import GlobalRoutePlanner
from carla_env.agents.navigation.global_route_planner_dao import GlobalRoutePlannerDAO
from carla_env.agents.navigation.local_planner import LocalPlanner
from carla_env.simulator.vehicles.ego_vehicle import EgoVehicle
from carla_env.utils.config import parse_config
from carla_env.simulator import Simulator
import carla

from envs.env_base import DynamicSequentialRouting, DDNNRouting, DynamicDistillRouting

import numpy as np
import argparse
import random
import os

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='experiment setting')
    parser.add_argument('--random_seed', action='store_true')
    parser.add_argument('--port', type=int, default=10012)
    args = parser.parse_args()

    config = parse_config('carla_configs/data_collect.yaml')

    test_envs = HighLevelBehaviorCloningCarlaEnvironment(config, port=args.port)
    test_envs.set_expert()

    # test_envs.select_route(8)
    # test_envs.reset()
    # done = False
    # while not done:
    #     state, reward, done, info = test_envs.step()


    traj_num = 20
    for i in range(traj_num):
        print()
        print('Route', i)
        # test_envs.select_route(i)
        test_envs.reset()
        done = False
        while not done:
            state, reward, done, info = test_envs.step()





