
"""Goal level 2."""

from safety_gymnasium.tasks.safe_navigation.goal.goal_level1 import GoalLevel1


class GoalLevel2(GoalLevel1):
    """An agent must navigate to a goal while avoiding more hazards and vases."""

    def __init__(self, config) -> None:
        super().__init__(config=config)
        # pylint: disable=no-member

        self.placements_conf.extents = [-2, -2, 2, 2]

        self.hazards.num = 10
        self.vases.num = 10
        self.vases.is_constrained = True
