clear
clc

load flip_para;

% Define the parameters for obstacles
px_obs_1 = 7.5;
py_obs_1 = 10;
r_obs_1 = 2.5;

px_obs_2 = 10;
py_obs_2 = 5;
r_obs_2 = 2.5;

% Define the parameters for goal 
pxg = 15; 
pyg = 15;
rg_s = 2;
rg = 1.5;

% Define the parameters for ellipsoid (CBF for side)
len_a = 5; len_b = 3;
xc_elp = 8.5; yc_elp = 7.5;
phi = -pi/3;



% Define the sampling time and Entire Time horizon
dt = 0.2;
T = 8; % Entire Horizon
Time = 0:dt:T;
N = length(Time); % Entire Horizon Steps

% Define the limitations for actions
dx_max = 3; dx_min = -3;
dy_max = 3; dy_min = -3;

% Define the initial state
px_ini = 0;
py_ini = 0;

% Parameter for Noise
delta = 0.6;
dxn_max = delta;
dyn_max = delta;

% Number of trajectories
n_tr = 1000;

n_ratio = 25;
s_all_ratio = cell(n_ratio,1);
a_all_ratio = cell(n_ratio,1);

for i_ratio=1:n_ratio

s_all = cell(n_tr,1);
a_all = cell(n_tr,1);

for i_tr=1:n_tr

w = w_ratio(:,i_ratio);
index_nonzero = find(w~=0);
len_w = length(index_nonzero);
if len_w==1
   filename = sprintf('trainedNetwork_%02d.mat', index_nonzero);
else
   w1 = w(index_nonzero(1));
   w2 = w(index_nonzero(2));
   sign_flip = rand(1,1);
   if sign_flip<=w1
      filename = sprintf('trainedNetwork_%02d.mat', index_nonzero(1));
   else
      filename = sprintf('trainedNetwork_%02d.mat', index_nonzero(2));
   end
end

    s_all_itr = zeros(2,N);
    s_all_itr(:,1) = [px_ini;py_ini;];
    a_all_itr = zeros(2,N-1);
    for i=2:N
        i_ratio
        i_tr
        i
        s_ini = s_all_itr(:,i-1);
        
        tic     
        loadedNet = load(filename);
        net = loadedNet.net;
        ap_nn_i = net(s_ini);
        toc

        dxn_i = randn(1,1)*dxn_max;
        dyn_i = randn(1,1)*dyn_max;
        ap_i = [ap_nn_i(1)+dxn_i;ap_nn_i(2)+dyn_i;];
        s_all_itr(:,i) = system_model(s_ini,ap_i,dt);
        a_all_itr(:,i-1) = [ap_nn_i(1);ap_nn_i(2);];
    end
    
    s_all{i_tr} = s_all_itr;
    a_all{i_tr} = a_all_itr;
end
s_all_ratio{i_ratio} = s_all;
a_all_ratio{i_ratio} = a_all;

end

save data_test_flip s_all_ratio a_all_ratio;
