#
# Plot of  experimental results

import numpy as np
import matplotlib.pyplot as plt

#Plotting parameters
horizon=21600
n_points=43200

with open('sw.txt', 'r') as f:
    lines = (line.strip() for line in f if line)
    sw = [float(line) for line in lines]
    
with open('in_signal.txt', 'r') as f:
    lines = (line.strip() for line in f if line)
    u = [float(line) for line in lines]

with open('target.txt', 'r') as f:
    lines = (line.strip() for line in f if line)
    z = [float(line) for line in lines]

with open('State.txt', 'r') as f:
    lines = (line.strip() for line in f if line)
    x = [float(line) for line in lines]

with open('Costate.txt', 'r') as f:
    lines = (line.strip() for line in f if line)
    p_x = [float(line) for line in lines]

with open('L.txt', 'r') as f:
    lines = (line.strip() for line in f if line)
    L = [float(line) for line in lines]

with open('H.txt', 'r') as f:
    lines = (line.strip() for line in f if line)
    H = [float(line) for line in lines]

with open('SignFlip.txt', 'r') as f:
    lines = (line.strip() for line in f if line)
    SignFlip = [float(line) for line in lines]

with open('FlipCounter.txt', 'r') as f:
    lines = (line.strip() for line in f if line)
    FlipCounter = [float(line) for line in lines]

#
# plot results
#
horizon=21600
point_T = 43200
period = 10
n_points = point_T * period

time = np.linspace(0, horizon, n_points)
plt.plot(time,z,'g-',linewidth=2,label='z')
plt.plot(time,u,'k-',linewidth=2,label='u')
plt.plot(time,x,'b-',linewidth=2,label='x')
#plt.plot(time,p_x,'r-',linewidth=2,label='p_x')
#plt.plot(time,sw,'k-',linewidth=2,label='overall square of the weights')
#plt.plot(time,w,'k-',linewidth=2,label='w')
#plt.plot(time,H,'g-',linewidth=2,label='Hamiltonian')
#plt.plot(time,L,'y-',linewidth=2,label='Lagrangian')
#plt.plot(time,SignFlip,'g-',linewidth=2,label='sign flip')
#plt.plot(time,FlipCounter,'k-',linewidth=2,label='flip counter')
plt.xlabel('time')
plt.ylabel('L(t),H(t)')
#plt.ylabel('z(t)')
#plt.ylabel('L and H: H=0 means no temporal dependcy: [H,H]=0')
#plt.ylabel('x, p optimal asymptotical vanishing')
plt.legend()
plt.show()
