load('result.mat')
num_markers = 10;
indices = find(time_vec1 <= 15); max_index = max(indices); time_vec1 = time_vec1(1:max_index); g_vec1 = g_vec1(1:max_index); f_vec1 = f_vec1(1:max_index);marker_idx1 = round(linspace(1, max_index, num_markers));
indices = find(time_vec2 <= 15); max_index = max(indices); time_vec2 = time_vec2(1:max_index); g_vec2 = g_vec2(1:max_index); f_vec2 = f_vec2(1:max_index);marker_idx2 = round(linspace(1, max_index, num_markers));
indices = find(time_vec3 <= 15); max_index = max(indices); time_vec3 = time_vec3(1:max_index); g_vec3 = g_vec3(1:max_index); f_vec3 = f_vec3(1:max_index);marker_idx3 = round(linspace(1, max_index, num_markers));
indices = find(time_vec4 <= 15); max_index = max(indices); time_vec4 = time_vec4(1:max_index); g_vec4 = g_vec4(1:max_index); f_vec4 = f_vec4(1:max_index);marker_idx4 = round(linspace(1, max_index, num_markers));
indices = find(time_vec5 <= 15); max_index = max(indices); time_vec5 = time_vec5(1:max_index); g_vec5 = g_vec5(1:max_index); f_vec5 = f_vec5(1:max_index);marker_idx5 = round(linspace(1, max_index, num_markers));
indices = find(time_vec6 <= 15); max_index = max(indices); time_vec6 = time_vec6(1:max_index); g_vec6 = g_vec6(1:max_index); f_vec6 = f_vec6(1:max_index);marker_idx6 = round(linspace(1, max_index, num_markers));
indices = find(time_vec7 <= 15); max_index = max(indices); time_vec7 = time_vec7(1:max_index); g_vec7 = g_vec7(1:max_index); f_vec7 = f_vec7(1:max_index);marker_idx7 = round(linspace(1, max_index, num_markers));
figure;
set(0,'defaulttextinterpreter','latex')
set(gcf,'DefaultLineLinewidth',5)
set(gcf,'DefaultLineMarkerSize',16);
set(gcf,'Position',[100, 100, 1400, 600])

position1 = [0.1, 0.1, 0.352, 0.8]; 
position2 = [0.53, 0.1, 0.457, 0.8];

%% Lower-level
ax1 = subplot('Position', position1);
h3 = semilogy(time_vec3, g_vec3, 's-', 'DisplayName', 'AGM-BiO', 'MarkerIndices', marker_idx3,'LineWidth',4, 'MarkerSize', 10);
hold on;
h4 = semilogy(time_vec4, g_vec4, 'd-', 'DisplayName', 'PB-APG', 'MarkerIndices', marker_idx4,'LineWidth',4, 'MarkerSize', 10);
h5 = semilogy(time_vec5, g_vec5, 's-', 'DisplayName', 'Bi-SG', 'MarkerIndices', marker_idx5,'LineWidth',4, 'MarkerSize', 10);
h6 = semilogy(time_vec6, g_vec6, 'x-', 'DisplayName', 'a-IRG', 'MarkerIndices', marker_idx6,'LineWidth',4, 'MarkerSize', 10);
h7 = semilogy(time_vec7, g_vec7, 'h-', 'DisplayName', 'CG-BiO', 'MarkerIndices', marker_idx7,'LineWidth',4, 'MarkerSize', 10);
h1 = semilogy(time_vec1, g_vec1, 'o-', 'DisplayName', 'FCB-BiO-smooth', 'MarkerIndices', marker_idx1,'LineWidth',4, 'MarkerSize', 10,'Color',[0.3010, 0.7450, 0.9330] );
h2 = semilogy(time_vec2, g_vec2, 'o-', 'DisplayName', 'FCB-BiO-Lipschitz', 'MarkerIndices', marker_idx2,'LineWidth',4, 'MarkerSize', 10,'Color', [0.33, 0.78, 0.33]);
ylabel('$g(\mathbf x_k)$')
xlabel('time (s)')
set(gca, 'FontSize', 20);
set(gca, 'YLim', [4e-4, 10])
set(gca, 'XLim', [0, 16])
set(gca, 'YTick', [1e-3, 1e-2,1e-1,1e0,10])
grid on;
grid minor;
pbaspect([1 0.8 1]);

%% Upper-level
ax2 = subplot('Position', position2);
h3 = semilogy(time_vec3, f_vec3, 's-', 'DisplayName', 'AGM-BiO', 'MarkerIndices', marker_idx3,'LineWidth',4, 'MarkerSize', 10);
hold on;
h4 = semilogy(time_vec4, f_vec4, 'd-', 'DisplayName', 'PB-APG', 'MarkerIndices', marker_idx4,'LineWidth',4, 'MarkerSize', 10);
h5 = semilogy(time_vec5, f_vec5, 's-', 'DisplayName', 'Bi-SG', 'MarkerIndices', marker_idx5,'LineWidth',4, 'MarkerSize', 10);
h6 = semilogy(time_vec6, f_vec6, 'x-', 'DisplayName', 'a-IRG', 'MarkerIndices', marker_idx6,'LineWidth',4, 'MarkerSize', 10);
h7 = semilogy(time_vec7, f_vec7, 'h-', 'DisplayName', 'CG-BiO', 'MarkerIndices', marker_idx7,'LineWidth',4, 'MarkerSize', 10);
h1 = semilogy(time_vec1, f_vec1, 'o-', 'DisplayName', 'FC-BiO\textsuperscript{\texttt{sm}}', 'MarkerIndices', marker_idx1,'LineWidth',4, 'MarkerSize', 10,'Color',[0.3010, 0.7450, 0.9330] );
h2 = semilogy(time_vec2, f_vec2, 'o-', 'DisplayName', 'FC-BiO\textsuperscript{\texttt{Lip}}', 'MarkerIndices', marker_idx2,'LineWidth',4, 'MarkerSize', 10,'Color', [0.33, 0.78, 0.33]);
ylabel('$f(\mathbf x_k)$')
xlabel('time (s)')
set(gca, 'FontSize', 20);
set(gca, 'YLim', [4e-3, 10])
set(gca, 'XLim', [0, 16])
set(gca, 'YTick', [1e-2,1e-1,1e0,10])
grid on;
grid minor;
pbaspect([1 0.8 1]);

lgd = legend([h1,h2,h3,h4,h5,h6,h7],'Interpreter', 'latex', 'Location', 'northeastoutside');
lgd.FontSize = 14;

print('Figure_OPR_FC-BiO','-depsc2','-r600')
exportgraphics(gcf, 'Figure_OPR_FC-BiO.pdf', 'ContentType', 'vector');