function [f_vec,g_vec,time_vec,x] = CG_BiO(fun_f,grad_f,grad_g,fun_g,param,x0)
epsilon_f= param.epsilonf;
epsilon_g= param.epsilong;
lambda = param.D;
maxiter = param.maxiter;

n = length(x0);
x = x0;
tic;
f_vec = [fun_f(x0)];
g_vec = [fun_g(x0)];
time_vec = [toc];

iter = 0;
while iter <= param.T0
    iter = iter+1;
    gam = 2/(iter+2);
    dir = linear_l2(grad_g(x),lambda);
    if (grad_g(x)'*(x-dir)<=epsilon_g) || (fun_g(x)<=epsilon_g)
        break;
    end
    x = (1-gam)*x + gam*dir;
    f_vec = [f_vec; fun_f(x)];
    g_vec = [g_vec;fun_g(x)];
    time_vec = [time_vec; toc];
end
fun_g_x0 = fun_g(x);

iter = 0;
while iter <= maxiter * 10
    if toc > param.maxT
        break;
    end
    iter = iter+1;
    gamma = 2/(iter+2);
    c = grad_f(x);
    w = grad_g(x);
    b = dot(grad_g(x),-x)-fun_g_x0+fun_g(x);
    opts = - c / norm(c,2) * sqrt(lambda);
    if dot(w,opts) + b > 0 % Project to Z \cap the approximated hyperplane.
        D = b/norm(w,2);
        C = - b/dot(w,w)*w;
        r = sqrt(lambda * lambda - D*D);
        proj_s = x - (dot(w,x)+b)/dot(w,w)*w;
        opts = (proj_s-C)/norm(proj_s-C)*r;
    end
    x = (1-gamma)*x + gamma*opts;

    f_vec = [f_vec;fun_f(x)];
    g_vec = [g_vec;fun_g(x)];
    time_vec = [time_vec;toc];
end
end

function x = linear_l2(c,lambda)
    x = -c / norm(c,2) * sqrt(lambda);
end