function [f_vec,g_vec,time_vec,x] = Bi_SG(fun_f,grad_f,grad_g,fun_g,param,x0)

maxiter = param.maxiter;
n = length(x0);
Lf = param.Lf;
Lg = param.Lg;
x = x0;
D = param.D;

%% Compute g_k, using accelerated method
tic;
iter = 0; 
f_vec = [];
g_vec = [];
time_vec = [];

f_vec = [f_vec;fun_f(x)];
g_vec = [g_vec;fun_g(x)];
time_vec = [time_vec;iter];
alpha = 0.75;
c = 1/Lf;
t = 1/Lg;

for k = 1:maxiter*10
    if toc > param.T
        break;
    end
    y = x - t * grad_g(x);
    y = proj_l2ball(y,D);
    eta = c*(k+1)^(-alpha);
    x = y - eta*grad_f(y);

    f_vec = [f_vec;fun_f(x)];
    g_vec = [g_vec;fun_g(x)];
    time_vec = [time_vec;toc];
    if toc >= param.T
        break;
    end
end
end
