function[f_vec,g_vec,time_vec,x] = Alg_Projection(fun_f,grad_f,grad_g,fun_g,param,x0)

eta_0 = 1000;
gamma_0 = 1e-1;
D = param.D;

f_vec = [];
g_vec = [];
time_vec = [];
x = x0;

maxiter = param.maxiter;
tic;
for k = 1 : maxiter*10
    eta_k = (eta_0)/(k+1)^0.25;
    gamma_k = gamma_0/sqrt(k+1);
    x = x - gamma_k*(grad_g(x)+eta_k*(grad_f(x)));
    x = proj_l2ball(x,D);
    f_vec = [f_vec;fun_f(x)];
    g_vec = [g_vec;fun_g(x)];
    time_vec = [time_vec;toc];
    if toc >= param.T
        break;
    end
end