function [f_vec,g_vec,time_vec,x] = AGM_BiO(fun_f,grad_f,grad_g,fun_g,param,x0)

maxiter = param.maxiter;
n = length(x0); 
Lf = param.Lf;
Lg = param.Lg; 
D = param.D;
tic;

%% AGM-BiO
f_vec = [];
g_vec = [];
time_vec = [];
gamma = 1/(2*(Lg/Lf)*maxiter^(2/3)+2);
x = x0; z = x0;
x_ = x0; z_ = x0;
A_ = 0;
g = [];
A = 0;
for k = 1 : maxiter*10
    ak_ = gamma * (k+1)/(4*Lg);
    y_ = (A_)/(A_+ak_)*x_ + (ak_)/(A_+ak_)*z_;
    z_ = z_ - ak_*grad_g(y_);
    x_ = (A_)/(A_+ak_)*x_ + (ak_)/(A_+ak_)*z_;
    A_ = A_ +ak_;
    g = [g;fun_g(x_)];
    
    ak = gamma * (k+1)/(4*Lf);
    y = (A)/(A+ak)*x + (ak)/(A+ak)*z;
    z = z - ak*grad_f(y);
    z = Proj_to_ballinhp(D, z,grad_g(y),fun_g(y)-dot(grad_g(y),y)-g(k));
    x = (A)/(A+ak)*x + (ak)/(A+ak)*z;
    A = A + ak;
    f_vec = [f_vec;fun_f(x)];
    g_vec = [g_vec;fun_g(x)];
    time_vec = [time_vec;toc];
    if toc >= param.T
        break;
    end
end
end
