function [f_vec,g_vec,time_vec,x,vec_t,vec_t_time] = FCB_BiO_Lipschitz(fun_f,grad_f,grad_g,fun_g,param,x0)

epsilon_f= param.epsilonf/2;
epsilon_g= param.epsilong/2;
epsilon = max(epsilon_f,epsilon_g);
maxiter = param.maxiter;
D = param.D;
n = length(x0);
eta = param.eta;

%% Compute g_k, using accelerated method
tic;
iter = 0; 
f_vec = [];
g_vec = [];
time_vec = [];
vec_t = [];
vec_t_time = [];

x = x0;
f_vec = [f_vec;fun_f(x)];
g_vec = [g_vec;fun_g(x)]; 
time_vec = [time_vec;iter];
gstar = 1000000;
for k = 1: 15000
    g_x = fun_g(x);
    gstar = min(gstar,g_x);
    f_vec = [f_vec;fun_f(x)];
    g_vec = [g_vec;g_x];
    time_vec = [time_vec;toc];
    x = x - eta * grad_g(x);
    proj_l2ball(x,D);
end
xstar_g = x;
fun_g = @(x) fun_g(x)-gstar;

%% 以下为二分
x = xstar_g;
LL = 0; RR = fun_f(xstar_g);
T = 8000;
while iter <= maxiter
    t = (LL+RR)/2;
    vec_t = [vec_t;t];
    vec_t_time = [vec_t_time;iter];
    lstiter = iter;
    min_ft = realmax;
     
    while iter -lstiter <= T && iter <= maxiter
        iter = iter + 1;
        f_x = fun_f(x); g_x = fun_g(x);
        if g_x >= f_x -t
            x = x - eta * grad_g(x);
        else 
            x = x - eta * grad_f(x);
        end
        proj_l2ball(x,D);
        f_vec = [f_vec;f_x];
        g_vec = [g_vec;g_x+gstar];
        time_vec = [time_vec;toc];
        min_ft = min(min_ft, max(f_x-t,g_x));
        if min_ft<=epsilon
            break;
        end
    end
    if min_ft<=epsilon
        RR = t;
    else 
        LL = t;
    end
end
end
