function[f_vec,g_vec,time_vec,x] = Alg_Projection(fun_f,grad_f,grad_g,fun_g,param,x0)
tic;
eta_0 = 1e-3;
gamma_0 = 1e-3;
maxiter = param.maxiter;
D=param.D

f_vec = [fun_f(x0)];
g_vec = [fun_g(x0)];
time_vec = [toc];
x = x0;

for k = 1 : maxiter * 10
    if toc > param.maxT
        break;
    end
    eta_k = (eta_0)/(k+1)^0.25;
    gamma_k = gamma_0/sqrt(k+1);
    x = x - gamma_k*(grad_g(x)+eta_k*(grad_f(x)));
    x = proj_l2ball(x,D);
    f_vec = [f_vec;fun_f(x)];
    g_vec = [g_vec;fun_g(x)];
    time_vec = [time_vec;toc];
end