function [f_vec,g_vec,time_vec,x] = AGM_BiO(fun_f,grad_f,grad_g,fun_g,param,x0)

maxiter = param.maxiter;
Lf = param.Lf;
Lg = param.Lg; 
gamma = param.gamma;
D = param.D;

tic;
f_vec = [fun_f(x0)];
g_vec = [fun_g(x0)];
time_vec = [toc];
x = x0; z = x0;
x_ = x0; z_ = x0;
A_ = 0;
A = 0;

for k = 1 : maxiter * 2
    if toc > param.maxT
        break;
    end
    ak_ = gamma * (k+1)/(4*Lg);
    y_ = (A_)/(A_+ak_)*x_ + (ak_)/(A_+ak_)*z_;
    z_ = z_ - ak_*grad_g(y_);
    x_ = (A_)/(A_+ak_)*x_ + (ak_)/(A_+ak_)*z_;
    A_ = A_ +ak_;

    ak = gamma * (k+1)/(4*Lf);
    y = (A)/(A+ak)*x + (ak)/(A+ak)*z;
    z = z - ak*grad_f(y);
    z = Proj_to_ballinhp(D,z,grad_g(y),fun_g(y)-dot(grad_g(y),y)-fun_g(x_));
    x = (A)/(A+ak)*x + (ak)/(A+ak)*z;
    A = A + ak;
    f_vec = [f_vec;fun_f(x)];
    g_vec = [g_vec;fun_g(x)];
    time_vec = [time_vec;toc];
end

end
