import os
import json
import glob
IMAGE_EXTENSIONS = ["jpg", "png", "JPEG", "jpeg"]

def get_class_to_id_mapping(train_root):
    # class_json - should contain a mapping of class names to integer IDs
    subfolders = os.listdir(train_root)
    # check if subfolders are numeric; if so take these to be the IDs
    class_to_idx = {}
    for subfolder in subfolders:
        class_to_idx[subfolder] = int(subfolder)
    return class_to_idx

def get_paths(path):
    all_paths = []
    for ext in IMAGE_EXTENSIONS:
        all_paths += glob.glob(os.path.join(path, f"**.{ext}"))
    return all_paths