#!/bin/bash

data='PACS'

for t in `seq 0 4`
do
  for domain in `seq 0 3`
  do
    CUDA_VISIBLE_DEVICES=0,1,2,3 python -m torch.distributed.launch --nproc_per_node=4 --master_port=29100 --use_env main_dg.py \
      --model vmamba_tiny \
      --batch-size 16 \
      --data $data \
      --target $domain \
      --seed $t \
      --data_root "/data/DataSets/" \
      --lr 5e-4 \
      --min-lr 1e-5 \
      --warmup-lr 1e-5 \
      --drop-path 0.0 \
      --weight-decay 1e-8 \
      --num_workers 16 \
      --output_dir ./output/vmamba_t \
      --epochs 50 \
      --finetune /path/pretrained_models/vmamba_tiny_e292.pth \
      --no_amp \
      --spatial_aug_flag 1 \
      --SeqTokenAug_flag 1 \
      --SeqTokenAug_p 1.0 \
      --SeqTokenAug_token_prob 0.75 \
      --SeqTokenAug_batch_prob 0.5 \
      --SeqTokenAug_token_attention_flag 1
  done
done

