from sklearn.ensemble import AdaBoostClassifier
import numpy as np

class DisjointMaj():
    def __init__(self, n_voting_classifiers, n_weak_classifiers, weak_classifier=None):
        self.n_voting_classifiers = n_voting_classifiers
        self.hypotheses = [AdaBoostClassifier(estimator=weak_classifier, n_estimators=n_weak_classifiers, algorithm='SAMME')
                           for _ in range(n_voting_classifiers)]

    def fit(self, X, y):
        partition_X = np.array_split(X, self.n_voting_classifiers)
        partition_y = np.array_split(y, self.n_voting_classifiers)
        for i in range(self.n_voting_classifiers):
            self.hypotheses[i].fit(partition_X[i], partition_y[i])
            self.hypotheses[i].n_classes_ = 2 # If partition has only one class, AdaBoostClassifier will throw an error

    def predict(self, X):
        return (sum([h.predict(X) for h in self.hypotheses]) > self.n_voting_classifiers//2)*1

    def score(self, X, y):
        return sum(self.predict(X) == y) / len(X)