_print_no_name() {
    local total_lines=$(awk 'END {print NR}' $CURRENT_FILE)
    cat $CURRENT_FILE | grep -n $ | head -n $(jq -n "[$CURRENT_LINE + $WINDOW/2, $WINDOW/2] | max | floor") | tail -n $(jq -n "$WINDOW")
}

# @yaml
# end_name: END_REPLACE
replace() {
    if [ -z "$CURRENT_FILE" ]
    then
        echo 'No file open. Use the `open` command first.'
        return
    fi

    local max_line=$(awk 'END {print NR}' $CURRENT_FILE)
    local start_line=$(jq -n "[1 + $CURRENT_LINE - $WINDOW/ 2, 1] | max")
    local end_line=$(jq -n "[$CURRENT_LINE + $WINDOW/2, $max_line] | min")

    # Bash array starts at 0, so let's adjust
    local start_line=$((start_line - 1))
    local end_line=$((end_line))  # we don't need to subtract 1 since the replacement is [start_line, end_line)

    local replacement=()
    while IFS= read -r line
    do
        replacement+=("$line")
    done

    # Read the file line by line into an array
    mapfile -t lines < "$CURRENT_FILE"
    local new_lines=("${lines[@]:0:$start_line}" "${replacement[@]}" "${lines[@]:$((end_line))}")
    # Write the new stuff directly back into the original file
    printf "%s\n" "${new_lines[@]}" >| "$CURRENT_FILE"

    _constrain_line
    echo "Your changes have been applied successfully. Here's what it looks like now:"
    _print_no_name
}