# @yaml
# signature: "edit <function_start_line>:<function_end_line>\n<new_function>\nend_of_edit"
# docstring: replaces the function starting at line function_start_line and ending at line function_end_line (inclusive) with your rewritten function (new_function). The new_function text should be terminated by a line with only end_of_edit on it. All of the <new_function> text will replace the existing function, so make sure your indentation is formatted properly.
# end_name: end_of_edit
edit() {
    if [ -z "$CURRENT_FILE" ]
    then
        echo 'No file open. Use the `open` command first.'
        return
    fi

    local start_line="$(echo $1: | cut -d: -f1)"
    local end_line="$(echo $1: | cut -d: -f2)"

    if [ -z "$start_line" ] || [ -z "$end_line" ]
    then
        echo "Usage: edit <function_start_line>:<function_end_line>"
        return
    fi

    local re='^[0-9]+$'
    if ! [[ $start_line =~ $re ]]; then
        echo "Usage: edit <function_start_line>:<function_end_line>"
        echo "Error: function_start_line must be a number"
        return
    fi
    if ! [[ $end_line =~ $re ]]; then
        echo "Usage: edit <function_start_line>:<function_end_line>"
        echo "Error: function_end_line must be a number"
        return
    fi

    # Bash array starts at 0, so let's adjust
    local start_line=$((start_line - 1))
    local end_line=$((end_line))

    local replacement=()
    while IFS= read -r line
    do    
        replacement+=("$line")
    done

    # Read the file line by line into an array
    mapfile -t lines < "$CURRENT_FILE"
    local new_lines=("${lines[@]:0:$start_line}" "${replacement[@]}" "${lines[@]:$((end_line))}")
    # Write the new stuff directly back into the original file
    printf "%s\n" "${new_lines[@]}" >| "$CURRENT_FILE"

    export CURRENT_LINE=$start_line
    _constrain_line
    _print
    echo "File updated. Please review the changes and make sure they are correct (correct indentation, no extra or duplicate lines, etc). Edit the file again if necessary."
}
