%% plot panel (b) and (c) in figure 1
cols = get(0, 'DefaultAxesColorOrder');
female = readmatrix('./data/growth_female_vel.txt');
male =  readmatrix('./data/growth_male_vel.txt');
qt = num2cell([female male],1);
qt = cellfun(@transpose,qt,'UniformOutput',false);
T = size(male,1);
N = length(qt);
t = linspace(0,1,T);
subject = 23;
alpha_val = 0.95;
gamma = t + alpha_val*t.*(t-1);
plot(t,qt{subject},'linewidth',8);
hold on
plot(t,interp1(t,qt{subject},gamma,'linear'),'r','linewidth',8);
plot(t,qComposeGamma(qt{subject},t,gamma),'color',cols(3,:),'linewidth',8);
hold off
legend(["Original","Value prsv.","Norm prsv."],'location','northeast')
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,"./figure/motivation_curves.png")
plot(t,gamma,'linewidth',8);
set(gca,'fontsize',55)
set(gcf,'position',[10,10,800,800])
pbaspect([1 1 1])
saveas(gcf,"./figure/motivation_warpings.png")

