%% Implement Gram-Schmidt procedure
% input: 
% F:  a matrix where each column is a function
% output:
% Q: orthonormalized functions
function Q = gram_schmidt_orthonormalization(F)
    [T, num_funcs] = size(F);
    t = 0:1/(T-1):1;
    Q = zeros(T, num_funcs);   
    for i = 1:num_funcs
        q = F(:, i);
        for j = 1:i-1
            proj = trapz(t, q.*Q(:,j)) * Q(:, j); 
            q = q - proj;
        end        
        q = q / sqrt(trapz(t,q.^2));
        Q(:, i) = q;
    end
end



