# generate data from warpMix model
# input: 
# n: number of individual curves;
# T: number of time points for discretized functions;
# mu: fixed effect function of length T;
# dataidx: 1, 2, or 3, corresponds to indeces for mu
# output: generated functions and true fixed effect function in subfolder "./data"
warpMixCurves = function(n, T, mu, dataidx){
  t = seq(0,1,length.out = T)
  # random effects
  baseU = create.bspline.basis(c(0,max(t)),norder = 3, breaks = seq(0,1,length.out = 5))
  mU = baseU$nbasis
  sigmaU = diag(0.25,mU)
  alphaU = t(mvrnorm(n,rep(0,mU),sigmaU))
  splineBasisU = eval.basis(t,baseU)
  U = splineBasisU %*% alphaU
  # error process
  epsilon = t(mvrnorm(n,rep(0,length(t)),0.0001 * diag(1,length(t))))
  X = as.vector(mu) + U + epsilon
  # phase functions
  baseW = create.bspline.basis(c(0,max(t)), norder = 5, breaks = c(0,0.6,1))
  mW = baseW$nbasis
  splineBasisW = eval.basis(t,baseW)
  theta = t(mvrnorm(n,rep(0,mW),diag(0.1,mW + 1e-3 * diag(1,mW))))
  wtheta = matrix(rep(0,n*length(t)),ncol = n)
  for (i in c(1:n)){
    wtheta[,i] = warpTimeFunction(splineBasisW,theta[,i],t)$warpTime
  }
  # data
  Y = matrix(0, nrow = length(t), ncol = n)
  for (i in c(1:n)){
    y = approxfun(wtheta[,i],X[,i])
    Y[,i] = y(t)
  }
  write.table(Y,paste("./data/warpMixData",dataidx,".csv",sep = ""), row.names = F,col.names = F)
  write.table(mu,paste("./data/warpMixData",dataidx,"_mu.csv",sep = ""),row.names = F,col.names = F)
  save.image(paste("./data/warpMixData",dataidx,".RData",sep = ""))
}